% author: Tz-Huan Huang [http://www.csie.ntu.edu.tw/~tzhuan]

% ----------------------------------------------------------------------------
% "THE CHOCOLATE-WARE LICENSE":
% Tz-Huan Huang wrote this file. As long as you retain this notice you
% can do whatever you want with this stuff. If we meet some day, and you think
% this stuff is worth it, you can buy me a chocolate in return Tz-Huan Huang
% ----------------------------------------------------------------------------

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{ntuthesis}[2013/04/23 Thesis template for National Taiwan University]

% Derived from book class
\DeclareRobustCommand{\@typeen}{Master}
\DeclareRobustCommand{\@typezh}{碩士}
\DeclareRobustCommand{\@classen}{Thesis}
\DeclareRobustCommand{\@classzh}{論文}
\DeclareOption{phd}{\gdef\@typeen{Doctoral}\gdef\@typezh{博士}\gdef\@classen{Dissertation}}
\DeclareOption{proposal}{\gdef\@typeen{Proposal for Doctoral}\gdef\@typezh{博士論文計畫提案書}\gdef\@classen{Dissertation}\gdef\@classzh{}}
\DeclareRobustCommand{\@setspacing}{\doublespacing}
\DeclareOption{singlespacing}{\gdef\@setspacing{\singlespacing}}
\DeclareOption{onehalfspacing}{\gdef\@setspacing{\onehalfspacing}}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{book}}
\ProcessOptions\relax
\LoadClass[a4paper,12pt]{book}

% Required packages
\RequirePackage[left=2cm,top=2.5cm,right=2cm,bottom=2.5cm,bindingoffset=1cm]{geometry}
\RequirePackage{xeCJK}
\RequirePackage{setspace}
\RequirePackage{titlesec}
\RequirePackage{chngcntr}
\RequirePackage{float}
\RequirePackage{tocloft}
\RequirePackage{array}
\RequirePackage{ragged2e}
\RequirePackage{etoolbox}

\newcolumntype{P}[1]{>{\RaggedRight\hspace{0pt}}p{#1}}

\setmainfont{Times New Roman}
\setCJKmainfont[AutoFakeBold=6,AutoFakeSlant=.4]{BiauKai}
\newCJKfontfamily\NewMingFont{PMingLiU}
\newCJKfontfamily\LiHeiFont{儷黑 Pro}
\newCJKfontfamily\HeiFont{儷黑 Pro}
\newCJKfontfamily\BiauKaiFont{BiauKai}

\titleformat{\chapter}[hang]
{\normalfont\huge\bfseries}{\chaptertitlename\ \thechapter}{1em}{}
\titlespacing*{\chapter}{0pt}{-50pt}{15pt}

\counterwithout{figure}{chapter}
\counterwithout{table}{chapter}
\counterwithout{equation}{chapter}

\floatstyle{plaintop}
\restylefloat{table}

%\def\l@figure{\@dottedtocline{1}{1.5em}{2.3em}}
%\def\l@table{\@dottedtocline{1}{1.5em}{2.3em}}

\setlength\cftbeforetoctitleskip{-1cm}
\setlength\cftbeforeloftitleskip{-1cm}
\setlength\cftbeforelottitleskip{-1cm}
\renewcommand{\cfttoctitlefont}{\hspace*{\fill}\Large\bfseries}
\renewcommand{\cftaftertoctitle}{\hspace*{\fill}}
\renewcommand{\cftlottitlefont}{\hspace*{\fill}\Large\bfseries}
\renewcommand{\cftafterlottitle}{\hspace*{\fill}}
\renewcommand{\cftloftitlefont}{\hspace*{\fill}\Large\bfseries}
\renewcommand{\cftafterloftitle}{\hspace*{\fill}}
\renewcommand{\cftfigfont}{Figure }
\renewcommand{\cftfignumwidth}{1em}
\renewcommand{\cftfigaftersnumb}{:~}
\renewcommand{\cfttabfont}{Table }
\renewcommand{\cfttabnumwidth}{1em}
\renewcommand{\cfttabaftersnumb}{:~}

\patchcmd{\@chapter}{\addtocontents{lof}{\protect\addvspace{10\p@}}}{}{}{}% LoF
\patchcmd{\@chapter}{\addtocontents{lot}{\protect\addvspace{10\p@}}}{}{}{}% LoT


% Declarations
\DeclareRobustCommand{\university}[2]{\gdef\@universityen{#1}\gdef\@universityzh{#2}}
\DeclareRobustCommand{\college}[2]{\gdef\@collegeen{#1}\gdef\@collegezh{#2}}
\DeclareRobustCommand{\institute}[2]{\gdef\@instituteen{#1}\gdef\@institutezh{#2}}
\DeclareRobustCommand{\title}[2]{\gdef\@titleen{#1}\gdef\@titlezh{#2}}
\DeclareRobustCommand{\author}[2]{\gdef\@authoren{#1}\gdef\@authorzh{#2}}
\DeclareRobustCommand{\studentid}[1]{\gdef\@studentid{#1}}
\DeclareRobustCommand{\advisor}[2]{\gdef\@advisoren{#1}\gdef\@advisorzh{#2}}
\DeclareRobustCommand{\defenseyear}[2]{\gdef\@yearen{#1}\gdef\@yearzh{#2}}
\DeclareRobustCommand{\defensemonth}[2]{\gdef\@monthen{#1}\gdef\@monthzh{#2}}
\DeclareRobustCommand{\defenseday}[1]{\gdef\@day{#1}}
\DeclareRobustCommand{\abstractname}[2]{\gdef\@abstractnameen{#1}\gdef\@abstractnamezh{#2}}
\DeclareRobustCommand{\acknowledgements}[2]{\gdef\@acknowledgementsen{#1}\gdef\@acknowledgementszh{#2}}

\abstractname{Abstract}{摘要}
\acknowledgements{Acknowledgements}{誌謝}

\DeclareRobustCommand{\makecover}{
  \begin{titlepage}
    \vspace{1cm}
    \begin{singlespace}
    \begin{center}
      \fontsize{38}{27}\selectfont
      \NewMingFont{國\hspace{0.3cm}立\hspace{0.3cm}交\hspace{0.3cm}通\hspace{0.3cm}大\hspace{0.3cm}學}\par
      \vspace{1.5cm}
      \fontsize{28}{27}\selectfont
      \LiHeiFont{\@institutezh}\par
      \vspace{1.5cm}
      \fontsize{24}{27}\selectfont
      \HeiFont{碩\hspace{0.5cm}士\hspace{0.5cm}論\hspace{0.5cm}文}\par
      \vspace{4cm}
      \fontsize{20}{27}\selectfont
      \BiauKaiFont{\textbf{\@titlezh}}\par
      \vspace{1.5cm}
      \fontsize{16}{27}\selectfont
      \@titleen\par
      \vspace{\fill}
      \fontsize{18}{27}\selectfont

      \BiauKaiFont{\hspace{-2cm}\hspace{-1.6cm}研\hspace{0.3cm}究\hspace{0.3cm}生：\@authorzh\hspace{2cm}}\par
      \BiauKaiFont{\hspace{-2cm}指導教授：\@advisorzh\hspace{0.3cm}教授}\par
      \vspace{\fill}

      \fontsize{16}{27}\selectfont
      \vspace{2cm}
      \HeiFont{\textbf{中\hspace{0.25cm}華\hspace{0.25cm}民\hspace{0.25cm}國\hspace{0.5cm}\@yearzh\hspace{0.3cm}年\hspace{0.3cm}\@monthzh\hspace{0.3cm}月}}\\
    \end{center}
    \end{singlespace}
    \vspace{1cm}
  \end{titlepage}
}


\DeclareRobustCommand{\makeinpage}{
  \begin{titlepage}
    \vspace{1cm}
    \begin{singlespace}
    \begin{center}
      \fontsize{14}{27}\selectfont
      \@titlezh\par
      \@titleen\par
      \vspace{\fill}
      \hspace{-0.3cm}研\hspace{0.25cm}究\hspace{0.25cm}生：\@authorzh\hspace{2cm}Student：\@authoren\par
      指導教授：\@advisorzh\hspace{2cm}Advisor：\@advisoren\par
      \vspace{1.5cm}
      \begin{onehalfspacing}
      國\hspace{0.18cm}立\hspace{0.18cm}交\hspace{0.18cm}通\hspace{0.18cm}大\hspace{0.18cm}學\par
      \vspace{0.3cm}
      網\hspace{0.18cm}路\hspace{0.18cm}工\hspace{0.18cm}程\hspace{0.18cm}研\hspace{0.18cm}究\hspace{0.18cm}所\par
      \vspace{0.3cm}
      碩\hspace{0.18cm}士\hspace{0.18cm}論\hspace{0.18cm}文\par
      \end{onehalfspacing}
      \vspace{1.5cm}
      \fontsize{12}{27}\selectfont
      A Thesis\par
      Submitted to Institute of Network Engineering\par
      \@collegeen\par
      \@universityen\par
      in partial Fulfillment of the Requirements\par
      for the Degree of\par
      \@typeen\par
      in\par
      Computer Science\par
      \@monthen\hspace{0.2cm}\@yearen\par
      Hsinchu, Taiwan, Republic of China\par
      \vspace{1.5cm}
      \fontsize{14}{27}\selectfont
      中華民國 \@yearzh 年 \@monthzh 月\\
    \end{center}
    \end{singlespace}
    \vspace{1cm}
  \end{titlepage}
}

%  stolen from CJKfntef
%
%  myCJKfilltwosides environment:
%    Align CJK characters to fill two sides.
%
%  Usage:
%    \begin{myCJKfilltwosides}{width}
%      first line \\
%      second line \\
%      ... \\
%      last line
%    \end{myCJKfilltwosides}
%
\newif\ifmyCJK@fillbegin@
\global\myCJK@fillbegin@false
\newif\ifmyCJK@filltwosides@
\global\myCJK@filltwosides@false

\newenvironment{myCJKfilltwosides}[1]{
  \leavevmode
  \vbox\bgroup
    \global\myCJK@filltwosides@true
    \global\let\myCJK@filltwosidesSymbol \CJKsymbol

    \def\myCJK@ftscr{
      \egroup
      \global\myCJK@fillbegin@false
      \hbox to #1\bgroup
        \ignorespaces}

    \let\\ \myCJK@ftscr

    \def\CJKsymbol##1{
      \ifmyCJK@fillbegin@
        \hfill
        \myCJK@filltwosidesSymbol{##1}
      \else
        \myCJK@filltwosidesSymbol{##1}
        \global\myCJK@fillbegin@true
      \fi}

    \hbox to #1\bgroup
      \ignorespaces
 }{
  \egroup
  \egroup

  \global\let\CJKsymbol \myCJK@filltwosidesSymbol
  \global\myCJK@fillbegin@false
  \global\myCJK@filltwosides@false}


\DeclareRobustCommand{\CJKmove}[1]{\raisebox{.35em}{#1}}
\DeclareRobustCommand{\makespine}{
  \noindent\rotatebox{-90}{
    \CJKfamily{sidepagefont}
    \begin{tabular}{m{3.5cm}m{0.1cm}m{2cm}m{0.1cm}m{10cm}m{1cm}m{2.5cm}m{0.1cm}m{1.5cm}}
      \fontsize{8}{6}\selectfont
      \begin{myCJKfilltwosides}{3cm}\CJKmove{\@universityzh}\end{myCJKfilltwosides}\newline
      \begin{myCJKfilltwosides}{3cm}\CJKmove{\@institutezh}\end{myCJKfilltwosides} & &
      \CJKmove{\@typezh\@classzh} & &
      {\fontsize{14}{14}\selectfont\CJKmove{\@titlezh}} & &
      {\fontsize{14}{14}\selectfont\CJKmove{\@authorzh{} 撰}} & &
      \raisebox{-0.25em}{\rotatebox{90}{\@yearzh{}} \rotatebox{90}{\hspace{0.25em}\@monthzh{}}}
    \end{tabular}}
}

\DeclareRobustCommand{\makecertification}{
  \if@openright\cleardoublepage\else\clearpage\fi
  \begin{singlespace}
  \begin{center}
    \fontsize{24}{36}\selectfont\@universityzh\@typezh{}學位\@classzh\\
    口試委員會審定書\par
    \vspace{0.5cm}
    {\fontsize{20}{30}\selectfont\@titlezh\par\@titleen\par}
  \end{center}
  \addcontentsline{toc}{chapter}{口試委員會審定書}
  \vspace{1cm}
  \fontsize{15}{24}\selectfont
\hspace{30pt}本論文係\@authorzh{}君 (\@studentid)
在\@universityzh\@institutezh{}完成之\@typezh{}學位\@classzh，%
於民國 \@yearzh 年 \@monthzh 月 \@day 日%
承下列考試委員審查通過及口試及格，特此證明\par
  \end{singlespace}
  \vspace{\fill}
  \begin{center}
  \begin{doublespace}
  \fontsize{15}{30}\selectfont
  \begin{tabular}{p{2.75cm}p{12.5cm}}
    \raisebox{30pt}{口試委員：} & \rule{11.5cm}{1pt} \\
    & \rule{5cm}{1pt}\hspace{1.5cm}\rule{5cm}{1pt} \\
    & \rule{5cm}{1pt}\hspace{1.5cm}\rule{5cm}{1pt} \\
    & \rule{5cm}{1pt}\hspace{1.5cm}\rule{5cm}{1pt} \\
    & \rule{5cm}{1pt}\hspace{1.5cm}\rule{5cm}{1pt} \\
    \raisebox{5pt}{所\hspace{15pt}長：} & \rule{8.5cm}{1pt}
  \end{tabular}
  \end{doublespace}
  \end{center}
  \vspace*{-1cm}
}

\newenvironment{quotationpage}[1]
  {\if@openright\cleardoublepage\else\clearpage\fi
   \chapter*{\centerline{#1}}
   \quotation}
  {\endquotation}

\newenvironment{abstracten}
  {
      \if@openright\cleardoublepage\else\clearpage\fi
      \begin{center}
          \textbf{\@titleen}\par
          Student: \@authoren\hspace{5cm} Advisor: \@advisoren\par
          \@instituteen\par
          \@universityen\par
          \vspace{2cm}
          \bf\@abstractnameen
      \end{center}

      \quotation
  }
  {\endquotation}

\newenvironment{abstractzh}
  {\if@openright\cleardoublepage\else\clearpage\fi
        \begin{center}
            \@titlezh\par
            \vspace{1cm}
            \bf 學生：\@authorzh\hspace{8cm} 指導教授：\@advisorzh\par
            \vspace{0.5cm}
            \@universityzh\@institutezh\par
            \vspace{2cm}
            \bf\@abstractnamezh\par
        \end{center}
   \quotation}
  {\endquotation}

\newenvironment{acknowledgementszh}
  {
      \if@openright\cleardoublepage\else\clearpage\fi
      \begin{center}
          \bf\@acknowledgementszh\par
      \end{center}
      \quotation
  }
  {
      \endquotation
      \begin{flushright}
          \@authorzh\hspace{0.3cm}謹致於\par
          \@yearen 年 \@monthzh 月 \@day 日
      \end{flushright}
  }

\newenvironment{acknowledgementsen}{\begin{quotationpage}{\@acknowledgementsen}}{\end{quotationpage}}
\DeclareRobustCommand{\keywordsen}[1]{\hspace{0.4cm}\textbf{Keywords:} #1}
\DeclareRobustCommand{\keywordszh}[1]{\hspace{0.4cm}\textbf{關鍵字：} #1}

\setcounter{tocdepth}{2}
\pagestyle{plain}
\@setspacing
