@ECHO OFF
set OpenCV_SRC=C:\OpenCV-2.1.0
IF NOT EXIST "%OpenCV_SRC%" (
	echo Can't find OpenCV Source, please change OpenCV_SRC setting
	GOTO END
)
if %PROCESSOR_ARCHITECTURE%==x86   set VS2010_ARCH=x86
if %PROCESSOR_ARCHITECTURE%==AMD64 set VS2010_ARCH=x86_amd64
if %PROCESSOR_ARCHITECTURE%==IA64  set VS2010_ARCH=x86_IPF
if %PROCESSOR_ARCHITECTURE%==x86   set CMAKE_GEN="Visual Studio 10"
if %PROCESSOR_ARCHITECTURE%==AMD64 set CMAKE_GEN="Visual Studio 10 Win64"
if %PROCESSOR_ARCHITECTURE%==IA64  set CMAKE_GEN="Visual Studio 10 IA64"
if %PROCESSOR_ARCHITECTURE%==x86   set BUILD_PLAT=x86
if %PROCESSOR_ARCHITECTURE%==AMD64 set BUILD_PLAT=x64
if %PROCESSOR_ARCHITECTURE%==IA64  set BUILD_PLAT=x64
echo !! OpenCV Source: [ %OpenCV_SRC% ]
echo !! Target architecture [ %VS2010_ARCH% ]

call "C:\Program Files (x86)\Microsoft Visual Studio 10.0\VC\vcvarsall.bat" %VS2010_ARCH%

set BUILD_DIR=build-%VS2010_ARCH%
set /p answer=Do you want to make clean first? (Y/N):
if %answer% == Y ( IF EXIST %BUILD_DIR% rmdir /s /q %BUILD_DIR% )
if %answer% == y ( IF EXIST %BUILD_DIR% rmdir /s /q %BUILD_DIR% )

:DO_MKDIR_CD
IF NOT EXIST %BUILD_DIR% mkdir %BUILD_DIR%
cd %BUILD_DIR%
if errorlevel 1 GOTO DO_MKDIR_CD


IF NOT EXIST CMakeCache.txt cmake -G %CMAKE_GEN% -D BUILD_PACKAGE=ON -D OPENCV_BUILD_3RDPARTY_LIBS=OFF -D BUILD_TESTS=OFF %OpenCV_SRC%
mkdir bin\Debug
type nul > bin\Debug\opencv_ffmpeg210d.dll
mkdir lib\Debug
type nul > lib\Debug\opencv_ffmpeg210d.lib
msbuild ALL_BUILD.vcxproj /p:configuration=Debug /p:BUILD_PLAT=%BUILD_PLAT%
msbuild ALL_BUILD.vcxproj /p:configuration=Release /p:BUILD_PLAT=%BUILD_PLAT%
:DO_PACKAGE
msbuild PACKAGE.vcxproj /p:configuration=Release /p:BUILD_PLAT=%BUILD_PLAT%
if errorlevel 1 GOTO DO_PACKAGE
:END
pause