# This is a monkeyrunner jython script that opens a connection to an Android
# device and continually sends a stream of swipe and touch gestures.
#
# See httpdeveloper.android.comguidedevelopingtoolsmonkeyrunner_concepts.html
#
# usage monkeyrunner swipe_monkey.py
#

# Imports the monkeyrunner modules used by this program
import sys
from com.android.monkeyrunner import MonkeyRunner, MonkeyDevice

# Connects to the current device
device = MonkeyRunner.waitForConnection()


# sets a variable with the package's internal name
package = 'tw.idv.JethroYu.tests'

# sets a variable with the name of an Activity in the package
activity = '.ListviewOnflingActivity'

# sets the name of the component to start
runComponent = package + '/' + activity

# A swipe left from (x1, y) to (x2, y) in 2 steps
start = (300, 720)
end = (300, 0)
duration = 0.18
steps = 6

for i in range(0, 100):
	print '_%d' % i
	device.press('KEYCODE_BACK', MonkeyDevice.DOWN_AND_UP)
	device.startActivity(component=runComponent)
	MonkeyRunner.sleep(0.1)
	device.drag(start, end, duration, steps)
	MonkeyRunner.sleep(2.5)
	device.touch(30, 30, MonkeyDevice.DOWN_AND_UP)
