 #
 # Copyright (C) 2011 The Reconfigurable Multi-resolutions Profiling Project
 #
 # Licensed under the Apache License, Version 2.0 (the "License");
 # you may not use this file except in compliance with the License.
 # You may obtain a copy of the License at
 #
 #      http://www.apache.org/licenses/LICENSE-2.0
 #
 # Unless required by applicable law or agreed to in writing, software
 # distributed under the License is distributed on an "AS IS" BASIS,
 # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 # See the License for the specific language governing permissions and
 # limitations under the License.

import sys
import os

def readProbe(file_src):
    list_probes = []
    new_mod = True

    probes_src = open(file_src, 'r')
    for line in probes_src:
        line = line.strip("\n")
        if new_mod == False and line == "---":
            new_mod = True
            continue
        elif new_mod == True:
            if line != "---":
                name = line.split()
                index = name[0].rindex(".")
                fn_name = name[0][0:index]
                list_probes.append(fn_name.replace(".", "/"))
                new_mod = False
        new_mod = False
    
    probes_src.close()
    return list_probes

def initJni(jnifile):
    jnifile.write('#include "probes.h"\n\n')
    jnifile.write('void nativeProbe(JNIEnv *env, jobject obj, jstring jname, jboolean f_type, jstring jcname, jboolean reg) {\n')
    jnifile.write('\tconst char *nname = (*env)->GetStringUTFChars(env, jname, 0);\n')
    jnifile.write('\tconst char *ncname = (*env)->GetStringUTFChars(env, jcname, 0);\n\n')
    
    jnifile.write('\tif(f_type == JNI_TRUE) {\n')
    
    jnifile.write('\t\tif(reg == JNI_TRUE) {\n')
    jnifile.write('\t\t\tif(isActiveProbe(nname) == 1)\n')
    jnifile.write('\t\t\t\tif(isRegCaller(ncname, nname) == 1)\n')
    jnifile.write('\t\t\t\t\tactiveLog(nname);\n\t\t}\n')
    
    jnifile.write('\t\telse {\n')
    jnifile.write('\t\t\tif(isActiveProbe(nname) == 1)\n')
    jnifile.write('\t\t\t\tif(isUnRegCaller(nname) == 1)\n')
    jnifile.write('\t\t\t\t\tactiveLog(nname);\n\t\t}\n')
    
    jnifile.write('\t}\n')
    jnifile.write('\telse {\n')
    jnifile.write('\t\tif(isActiveProbe(nname) == 1)\n')
    jnifile.write('\t\t\tactiveLog(nname);\n\t}\n\n')
    
    jnifile.write('\t(*env)->ReleaseStringUTFChars(env, jname, nname);\n')
    jnifile.write('\t(*env)->ReleaseStringUTFChars(env, jcname, ncname);\n}\n\n')

def initUpdate(jnifile):
    jnifile.write('JNIEXPORT void JNICALL Java_android_util_UpdateFramework_nativeUpdate(JNIEnv *env, jobject obj) {\n')
    jnifile.write('\tupdateSystem();\n}\n\n')

def initClean(jnifile):
    jnifile.write('JNIEXPORT void JNICALL Java_android_util_UpdateFramework_nativeClean(JNIEnv *env, jobject obj) {\n')
    jnifile.write('\tcleanLogList();\n}\n\n')   

def genProbeJNI(list_probe, name):  
    jnifile = open(name, "w")
    initJni(jnifile)
    
    if name == "frameProbes.c":
        initUpdate(jnifile)
        initClean(jnifile)
    
    jnifile.write('JNIEXPORT jint JNICALL JNI_OnLoad(JavaVM* vm, void *reserved) {\n')
    jnifile.write('\tJNIEnv* env = NULL;\n')
    jnifile.write('\tjint result = -1;\n\n')
    jnifile.write('\tif ((*vm)->GetEnv(vm, (void**) &env, JNI_VERSION_1_4) != JNI_OK) {\n')
    jnifile.write('\t\tLOGI("ERROR: GetEnv failed");\n')
    jnifile.write('\t\tgoto tail;\n')
    jnifile.write('\t}\n\n')
    jnifile.write('\tif (initProbesSys() == -1) {\n')
    jnifile.write('\t\tLOGI("ERROR: initProbesSys failed");\n')
    jnifile.write('\t\tgoto tail;\n\t}\n\n')
    jnifile.write('\tjclass classz;\n')
    jnifile.write('\tJNINativeMethod methods[] =\n\t{\n\t\t{\n')
    jnifile.write('\t\t\t"probe", "(Ljava/lang/String;ZLjava/lang/String;Z)V", (void *) nativeProbe\n')
    jnifile.write('\t\t},\n\t};\n\n')
    
    for probe in list_probe:
        jnifile.write('\tclassz = (*env)->FindClass (env, "%s");\n' % (probe))
        jnifile.write('\t(*env)->RegisterNatives(env, classz, methods, 1);\n\n')
    
    jnifile.write('\tLOGI("JNI_OnLoad");\n\n')
    jnifile.write('\tresult = JNI_VERSION_1_4;\n')
    jnifile.write('tail:\n')
    jnifile.write('\treturn result;\n}\n\n')
 
if __name__ == "__main__":
    if len(sys.argv) < 2:
        print("Error format: genJNI.py <appProbes> <frameProbes>")
        sys.exit()
    else:
        list_probes = readProbe(sys.argv[1])
        genProbeJNI(list_probes, "appProbes.c")
        
        list_probes = readProbe(sys.argv[2])
        genProbeJNI(list_probes, "frameProbes.c")
        
        print("Finish")