/*
 * Copyright (C) 2011 The Reconfigurable Multi-resolutions Profiling Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "probes.h"

int initProbesSys()
{
	FILE *config = NULL;
	int size;	//log size(memory bound)
	char buf[MAX_BUF];
	
	config = fopen(CONFIGFILE, "r");
	if (config == NULL)
	{
		LOGI("Error: Can't open [%s]", CONFIGFILE);
		return -1;
	}
	
	if (fgets(buf, MAX_BUF, config) == NULL)
	{
		LOGI("Error: Can't read number of items");
		return -1;
	}
	
	size = atoi(buf);
	if (size < 0)
	{
		LOGI("Error: Get error value in size of config (%d)", size);
		return -1;
	}

	if(loadActiveProbe() == -1 || initLogSpace(size) == -1 || loadCaller() == -1)
		return -1;
		
	if (config != NULL) fclose(config);

	return 0;
}

void closeProbeSys()
{
	unloadActiveProbe();
	desLogSpace();
	unloadCaller();
}

void updateSystem()
{
	closeProbeSys();
	initProbesSys();
}
