/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Copyright (C) 2011 The Reconfigurable Multi-resolutions Profiling Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package rmp;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;

import javax.swing.*;
import javax.swing.table.TableColumn;

public class rmpGUI extends javax.swing.JFrame {
	private JMenuItem callGraphMenuItem;
	private JMenuItem analysisResultMenuItem;
	private JMenu runMenu;
	private JMenuItem exitMenuItem;
	private JSeparator mainMenuSeparator;
	private JMenuItem logSpaceMenuItem;
	private JMenuItem saveMenuItem;
	private JMenu settingsMenu;
	private JMenuBar mainMenuBar;
	private JLabel statusLabel;
	private JTextField filterTextField;
	private JButton filterButton;
	private JLabel filterNameLabel;
	private JTable frameCallerTable;
	private JTable appCallerTable;
	private JScrollPane frameCallerScrollPane;
	private JScrollPane appCallerScrollPane;
	private JPanel callerPanel;
	private JTable probesTable;
	private JScrollPane probeScrollPane;
	//--------------------------------------------//
	private ProbeTableMode pTableMode;
	private ListSelectionModel listSelectionModel;
	private InfDialog infDialog;
	private CallGraphDialog callDialog; 
	
	private AppCallerTableMode appTableMode;
	private FrameCallerTableMode frameTableMode;
	private LogSpace logspace;
	private ConfigLogSpace configLogsize;
	private ResultDatabase resultData;

	public rmpGUI() {
		super();
		//init components
		pTableMode = new ProbeTableMode();
		resultData = new ResultDatabase();
		appTableMode = new AppCallerTableMode();
		frameTableMode = new FrameCallerTableMode();
		logspace = new LogSpace();
		configLogsize = new ConfigLogSpace(this, logspace);
		infDialog = new InfDialog(this, resultData, "null");
		callDialog = new CallGraphDialog(this, resultData);
		initGUI();
	}
	//update status bar
	public String updateStatus() {
		StringBuffer rtn = new StringBuffer();
		
		rtn.append("Log-space: ").append(logspace.getLogSpace()).append(" | ");
		rtn.append("Number of probes: ").append(pTableMode.getRowCount());
		
		return rtn.toString();
	}
	
	public String updateStatus(int logSize) {
		StringBuffer rtn = new StringBuffer();
		
		rtn.append("Log-space: ").append(logspace.getLogSpace()).append(" | ");
		rtn.append("Number of probes: ").append(pTableMode.getRowCount()).append(" | ");
		rtn.append("Log size: ").append(logSize).append(" (byte)");
		return rtn.toString();
	}
	
	private void initGUI() {
		try {
			{
				this.setSize(800, 600);
				getContentPane().setLayout(null);
				this.setTitle("DMP");
				{
					probeScrollPane = new JScrollPane();
					getContentPane().add(probeScrollPane);
					probeScrollPane.setBounds(0, 32, 598, 458);
					{
						probesTable = new JTable();
						listSelectionModel = probesTable.getSelectionModel();
						listSelectionModel.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
						//listSelectionModel.addListSelectionListener(new InfSelectionHandler());
						
						probeScrollPane.setViewportView(probesTable);
						probesTable.setModel(pTableMode);
						probesTable.setAutoCreateRowSorter(true);
						probesTable.addMouseListener(new MouseAdapter()
						{
							//double click probes with right button of mouse and add them to caller filter list
							@Override
						    public void mouseReleased(MouseEvent e)
						    {
						        if (e.getClickCount() == 2 && e.getButton() == MouseEvent.BUTTON1)
						        {
						        	probesTable.changeSelection(
						        			probesTable.rowAtPoint(e.getPoint()), 
						        			probesTable.columnAtPoint(e.getPoint()), 
						                false, false);

						        	if(pTableMode.isApp(probesTable.getValueAt(probesTable.getSelectedRow(), 0).toString()))
						        		appTableMode.addValue(probesTable.getValueAt(probesTable.getSelectedRow(), 0).toString());
						        	else
						        		frameTableMode.addValue(probesTable.getValueAt(probesTable.getSelectedRow(), 0).toString());
						        }
						    }
							
							//double click probes with left button of mouse and add them to caller filter list
						    @Override
						    public void mouseClicked(MouseEvent e)
						    {
						        if (e.getModifiers() == MouseEvent.BUTTON3_MASK)
						        {
						        	probesTable.changeSelection(
						        			probesTable.rowAtPoint(e.getPoint()), 
						        			probesTable.columnAtPoint(e.getPoint()), 
						                false, false);
						        	infDialog.setName(probesTable.getValueAt(probesTable.getSelectedRow(), 0).toString());
						        	infDialog.setModal(true);
						        	infDialog.setVisible(true);
						        }
						    }
						});
						
						TableColumn column = null;
						column = probesTable.getColumnModel().getColumn(0);
						column.setPreferredWidth(350);
					}
				}
				{
					callerPanel = new JPanel();
					getContentPane().add(callerPanel);
					callerPanel.setBounds(599, 1, 185, 498);
					{
						appCallerScrollPane = new JScrollPane();
						callerPanel.add(appCallerScrollPane);
						appCallerScrollPane.setPreferredSize(new java.awt.Dimension(188, 236));
						{
							appCallerTable = new JTable();
							appCallerScrollPane.setViewportView(appCallerTable);
							appCallerTable.setModel(appTableMode);
							appCallerTable.setAutoCreateRowSorter(true);
							appCallerTable.addMouseListener(new MouseAdapter()
							{
								//remove the probe from caller filter list
								@Override
							    public void mouseReleased(MouseEvent e)
							    {
							        if (e.getClickCount() == 2 && e.getButton() == MouseEvent.BUTTON1)
							        {
							        	appTableMode.removeValue(appTableMode.getValueAt(appCallerTable.getSelectedRow(), 0));
							        }
							    }
							});
						}
					}
					{
						frameCallerScrollPane = new JScrollPane();
						callerPanel.add(frameCallerScrollPane);
						frameCallerScrollPane.setPreferredSize(new java.awt.Dimension(191, 247));
						{
							frameCallerTable = new JTable();
							frameCallerScrollPane.setViewportView(frameCallerTable);
							frameCallerTable.setModel(frameTableMode);
							frameCallerTable.setAutoCreateRowSorter(true);
							frameCallerTable.addMouseListener(new MouseAdapter()
							{
								@Override
							    public void mouseReleased(MouseEvent e)
							    {
							        if (e.getClickCount() == 2 && e.getButton() == MouseEvent.BUTTON1)
							        {
							        	frameTableMode.removeValue(frameTableMode.getValueAt(frameCallerTable.getSelectedRow(), 0));
							        }
							    }
							});
						}
					}
				}
				{
					filterNameLabel = new JLabel();
					getContentPane().add(filterNameLabel);
					filterNameLabel.setText("Filter: ");
					filterNameLabel.setBounds(7, 5, 44, 24);
				}
				{
					filterTextField = new JTextField();
					getContentPane().add(filterTextField);
					filterTextField.setText("");
					filterTextField.setBounds(55, 5, 472, 24);
				}
				{
					filterButton = new JButton();
					getContentPane().add(filterButton);
					filterButton.setText("filter");
					filterButton.setBounds(531, 5, 63, 27);
					
					filterButton.addActionListener(new ActionListener()
					{
						@Override
						public void actionPerformed(ActionEvent arg0) {
							//clean all select
							pTableMode.cleanSelect();
							//parse
							String[] cmd = filterTextField.getText().split("&&");
							for (int i=0;i<cmd.length;i++)
							{
								cmd[i] = cmd[i].trim();
								if (cmd[i].startsWith("level"))
								{
									String[] str = cmd[i].split(" ");
									if (str.length == 3)
									{
										if (str[2].equals("process"))
										{
											pTableMode.setProbesLevel(str[2], i);
											filterTextField.setText("");
										}
										else if (str[2].equals("thread"))
										{
											pTableMode.setProbesLevel(str[2], i);
											filterTextField.setText("");
										}
										else if (str[2].equals("method"))
										{
											pTableMode.setProbesLevel(str[2], i);
											filterTextField.setText("");
										}
										else if (str[2].equals("loop"))
										{
											pTableMode.setProbesLevel(str[2], i);
											filterTextField.setText("");
										}
										else
										{
											filterTextField.setText("Error filter");
										}
									}
									else
									{
										filterTextField.setText("Error filter");
									}
								}
								else if (cmd[i].startsWith("times"))
								{
									String[] str = cmd[i].split(" ");
									if (str.length == 3)
									{
										pTableMode.setProbesTimes(str[1], Long.parseLong(str[2]), i);
									}
									else
									{
										filterTextField.setText("Error filter");
									}
								}
								else if (cmd[i].startsWith("time"))
								{
									String[] str = cmd[i].split(" ");
									if (str.length == 3)
									{
										pTableMode.setProbesTime(str[1], Long.parseLong(str[2]), i);
									}
									else
									{
										filterTextField.setText("Error filter");
									}
								}
								else
								{
									filterTextField.setText("Error filter");
								}
							}
						}							
					});
				}
				{
					statusLabel = new JLabel();
					getContentPane().add(statusLabel);
					statusLabel.setText(updateStatus());
					statusLabel.setBounds(12, 509, 500, 13);
				}
			}
			{
				mainMenuBar = new JMenuBar();
				setJMenuBar(mainMenuBar);
				{
					settingsMenu = new JMenu();
					mainMenuBar.add(settingsMenu);
					settingsMenu.setText("Settings");
					{
						logSpaceMenuItem = new JMenuItem();
						settingsMenu.add(logSpaceMenuItem);
						logSpaceMenuItem.setText("Log-space");
						logSpaceMenuItem.addActionListener(new ActionListener()
						{
							@Override
							public void actionPerformed(ActionEvent arg0) {
								configLogsize.setModal(true);
								configLogsize.setVisible(true);
								statusLabel.setText(updateStatus());
							}							
						});
					}
					{
						saveMenuItem = new JMenuItem();
						settingsMenu.add(saveMenuItem);
						saveMenuItem.setText("Save config");
						saveMenuItem.addActionListener(new ActionListener()
						{
							@Override
							public void actionPerformed(ActionEvent arg0) {
								logspace.saveConfig();
								pTableMode.saveConfig();
								appTableMode.saveConfig();
								frameTableMode.saveConfig();
							}							
						});
					}
					{
						mainMenuSeparator = new JSeparator();
						settingsMenu.add(mainMenuSeparator);
					}
					{
						exitMenuItem = new JMenuItem();
						settingsMenu.add(exitMenuItem);
						exitMenuItem.setText("Exit");
						exitMenuItem.addActionListener(new ActionListener()
						{
							@Override
							public void actionPerformed(ActionEvent arg0) {
								System.exit(0);								
							}							
						});
					}
				}
				{
					runMenu = new JMenu();
					mainMenuBar.add(runMenu);
					runMenu.setText("Run");
					{
						analysisResultMenuItem = new JMenuItem();
						runMenu.add(analysisResultMenuItem);
						analysisResultMenuItem.setText("Analysis result");
						analysisResultMenuItem.addActionListener(new ActionListener()
						{
							@Override
							public void actionPerformed(ActionEvent arg0) {
								//update results
								int newLogSize = resultData.update(pTableMode, appTableMode, frameTableMode);
								pTableMode.cleanData();
								//show results on table
								if (resultData.haveTimeResult())
								{
									for (int i=0;i<resultData.getSize();i++)
									{
										Vector<String> inChildName = new Vector<String>();
										Vector<String> childName = new Vector<String>();
										Vector<Integer> childID = resultData.getData(i).getChild();
										for (int j=0;j<childID.size();j++)
										{
											childName.add(resultData.getData(childID.elementAt(j)).getName());
											resultData.collectChildName(childID.elementAt(j), inChildName);
										}
										
										pTableMode.setTimeResult(resultData.getData(i), childName, inChildName);
									}
									pTableMode.calTimeAvg();
								}
								
								if (resultData.haveEnergyResult())
								{
									resultData.calEnergy();
									for (int i=0;i<resultData.getSize();i++)
									{										
										pTableMode.setEnergyResult(resultData.getData(i));
									}
									pTableMode.calEnergyAvg();
								}
								
								statusLabel.setText(updateStatus(newLogSize));
							}							
						});
					}
					{
						callGraphMenuItem = new JMenuItem();
						runMenu.add(callGraphMenuItem);
						callGraphMenuItem.setText("Call graph");
						callGraphMenuItem.addActionListener(new ActionListener()
						{
							@Override
							public void actionPerformed(ActionEvent arg0) {
								callDialog.getCallGraph();
								callDialog.setModal(true);
								callDialog.setVisible(true);
							}							
						});
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
