/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Copyright (C) 2011 The Reconfigurable Multi-resolutions Profiling Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package rmp;

import java.util.Vector;
//analyze profiling results by stack
public class ResultContent {
	private Vector<ResultData> stack;
	private int count;
	
	public ResultContent()
	{
		stack = new Vector<ResultData>();
		count = 0;
	}
	
	public boolean push(ResultData result)
	{
		if (stack.size() >= 1)
		{
			long really_result = -1;
			ResultData temp = stack.get(0);
			if (temp.getName().equals(result.getName()))
			{
				//caculate inclusive time result
				really_result = result.getInclusiveResult() - temp.getInclusiveResult();
				if (really_result < 0)
					really_result = -1;
				temp.setInclusiveResult(really_result);
				
				temp.setTail(result.getInclusiveResult());
				temp.setNoLog(temp.getNoLog() + result.getNoLog());
				
				if (stack.size() > 1)	//have caller
				{
					temp.setCaller(stack.get(1).getID());
					//if (really_result >= 0)
					//	stack.get(1).setExcludeTime(new_time);
					stack.get(1).setChild(temp.getID());
				}
				else
					temp.setCaller(-1);

				return true;
			}
			else
			{
				result.setHead(result.getInclusiveResult());
				result.setID(count++);	
				stack.add(0, result);
			}
		}
		else
		{
			result.setHead(result.getInclusiveResult());
			result.setID(count++);
			stack.add(0, result);
		}

		return false;
	}
	
	public ResultData pop()
	{
		//ResultData temp = stack.get(0);
		//temp.setResult(temp.getResult() - temp.getExcludeTime());
		return stack.remove(0);
	}
	
	public ResultData stackFirstElement()
	{
		if (stack.size() != 0)
			return stack.firstElement();
		else
			return null;
	}
}
