/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Copyright (C) 2011 The Reconfigurable Multi-resolutions Profiling Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package rmp;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

/**
* This code was edited or generated using CloudGarden's Jigloo
* SWT/Swing GUI Builder, which is free for non-commercial
* use. If Jigloo is being used commercially (ie, by a corporation,
* company or business for any purpose whatever) then you
* should purchase a license for each developer using Jigloo.
* Please visit www.cloudgarden.com for details.
* Use of Jigloo implies acceptance of these licensing terms.
* A COMMERCIAL LICENSE HAS NOT BEEN PURCHASED FOR
* THIS MACHINE, SO JIGLOO OR THIS CODE CANNOT BE USED
* LEGALLY FOR ANY CORPORATE OR COMMERCIAL PURPOSE.
*/
public class ConfigLogSpace extends javax.swing.JDialog {
	private LogSpace logsize;
	private JPanel logsizePanel;
	private JButton cancelButton;
	private JButton editButton;
	private JLabel logsizeLabel;
	private JTextField logsizeTextField;

	public ConfigLogSpace(JFrame frame, LogSpace logsize) {
		super(frame);
		this.logsize = logsize;
		initGUI();
	}
	
	private void initGUI() {
		try {
			{
				logsizePanel = new JPanel();
				getContentPane().add(logsizePanel, BorderLayout.CENTER);
				logsizePanel.setLayout(null);
				logsizePanel.setPreferredSize(new java.awt.Dimension(197, 84));
				logsizePanel.setLayout(null);
				{
					logsizeTextField = new JTextField();
					logsizePanel.add(logsizeTextField);
					logsizeTextField.setText(String.valueOf(logsize.getLogSpace()));
					logsizeTextField.setBounds(77, 12, 108, 24);
				}
				{
					logsizeLabel = new JLabel();
					logsizePanel.add(logsizeLabel);
					logsizeLabel.setText("Log-space:");
					logsizeLabel.setBounds(10, 15, 63, 17);
				}
				{
					editButton = new JButton();
					logsizePanel.add(editButton);
					editButton.setText("Edit");
					editButton.setBounds(12, 48, 74, 24);
					editButton.addActionListener(new ActionListener()
					{
						@Override
						public void actionPerformed(ActionEvent arg0) {
							logsize.setLogSpace(Integer.parseInt(logsizeTextField.getText()));
							dispose();
						}							
					});
				}
				{
					cancelButton = new JButton();
					logsizePanel.add(cancelButton);
					cancelButton.setText("Cancel");
					cancelButton.setBounds(97, 48, 88, 24);
					cancelButton.addActionListener(new ActionListener()
					{
						@Override
						public void actionPerformed(ActionEvent arg0) {
							dispose();					
						}							
					});
				}
			}
			this.setSize(215, 122);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
