/*
 * Copyright (C) 2011 The Reconfigurable Multi-resolutions Profiling Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "logsys.h"

FILE *output = NULL;
int max_size, pos;
struct logdata *list_data;

int activeLog(const char *name)	//store time result
{
	//LOGI("activeLog\n");
	
	list_data[pos].name = (char *)malloc(sizeof(char) * strlen(name) + 1);
	strcpy(list_data[pos].name, name);
	clock_gettime(CLOCK_MONOTONIC, &(list_data[pos].now));
	pos++;
	
	//out of bound, clean memory's logs
	if(pos == max_size)
	{
		int result = cleanLogList();
		if(result == -1)
			return -1;
	}

	//LOGI("EactiveLog\n");
	return 0;
}

int cleanLogList()	//clean log space
{
	//LOGI("cleanLogList\n");
	
	if (pos == 0)
		return 0;
	
	int i;
	char temp[MAX_BUF];

	for(i=0;i<pos;i++)
	{
		fwrite(list_data[i].name, strlen(list_data[i].name), 1, output);
		free(list_data[i].name);
		sprintf(temp, " %ld %ld\n", list_data[i].now.tv_sec, list_data[i].now.tv_nsec);
		fwrite(temp, strlen(temp), 1, output);
	}
	pos = 0;
	fflush(output);
	
	//LOGI("EcleanLogList\n");
	return 0;
}

int initLogSpace(int size)
{
	//LOGI("initLogSpace\n");
	pos = 0;
	max_size = size;
	list_data = (struct logdata *)malloc(sizeof(struct logdata) * size);
	
	output = fopen(LOGFILE, "w");
	if (output == NULL)
	{
		LOGI("Error: Can't open [%s]", LOGFILE);
		return -1;
	}

	//LOGI("EinitLogSpace\n");
	return 0;
}

void desLogSpace()	//free the log space
{
	//LOGI("desLogSpace\n");
	cleanLogList();
	if (output != NULL) fclose(output);
	free(list_data);
	//LOGI("EdesLogSpace\n");
}
