/*
 * Copyright (C) 2011 The Reconfigurable Multi-resolutions Profiling Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "activeprobe.h"

int probe_items;
BLOOM *bloom;

unsigned int add_hash(const char *key)
{
	unsigned int h=0;

	while(*key) h+=*key++;

	return h;
}

unsigned int sdbm_hash(const char *key)
{
	unsigned int h=0;
	while(*key) h=(unsigned char)*key++ + (h<<6) + (h<<16) - h;
	return h;
}

int isActiveProbe(const char *input)
{
	if(bloom_check(bloom, input))
		return 1;

	return -1;
}

int loadActiveProbe()
{
	FILE *probe_file = NULL;
	int i;
	char buf[MAX_BUF];
	char *data;
	
	//LOGI("loadActiveProbe\n");
	if(!(bloom=bloom_create(2500000, 1, add_hash))) {
		//LOGI("Error: Could not create bloom filter\n");
		//printf("Error: Could not create bloom filter\n");
		return -1;
	}
	
	probe_file = fopen(PROBELIST, "r");
	if (probe_file == NULL)
	{
		LOGI("Error: Can't open [%s]", PROBELIST);
		return -1;
	}
	
	//read the number of probe_items
	memset(buf, 0, sizeof(buf));
	if (fgets(buf, MAX_BUF, probe_file) != NULL)
	{
		probe_items = atoi(buf);
		if (probe_items < 0)
		{
			LOGI("Error: Get error value in number of probe_items (%d)", probe_items);
			return -1;
		}
	}
	else
	{
		LOGI("Error: Can't read number of probe_items");
		return -1;
	}
	
	//store name of probes	
	for(i=0;i<probe_items;i++)
	{
		memset(buf, 0, sizeof(buf));
		if(fgets(buf, MAX_BUF, probe_file) != NULL)
		{
			int str_len;
			str_len = atoi(buf);
			if(fgets(buf, MAX_BUF, probe_file) != NULL)
			{
				data = (char *)malloc(sizeof(char) * str_len + 2);
				strncpy(data, buf, str_len);
				data[str_len] = '\0';
				bloom_add(bloom, data);
			}
			else
			{
				LOGI("Error: Can't read name of probes");
				return -1;
			}
		}
		else
		{
			LOGI("Error: Can't read len of name");
			return -1;
		}
	}

	if (probe_file != NULL) fclose(probe_file);
		
	//check
	/*for(i=0;i<probe_items;i++)
		LOGI("Index(%d):%d[%s]", i, strlen(list_probes[i]), list_probes[i]);*/
		
	//LOGI("Finish load name of probes");
	return 0;
}

void unloadActiveProbe()
{
	//LOGI("unloadActiveProbe\n");
	bloom_destroy(bloom);
	//LOGI("EunloadActiveProbe\n");
}
