#include "activeprobe.h"

int probe_items;
char **list_probes;

int isActiveProbe(const char *input)
//int isActiveProbe(char *input)
{
	int result;
	int low = 0;
	int upper = probe_items - 1;
	
	//printf("%s at isActiveProbe?\n");
	//LOGI("%s at isActiveProbe?\n", input);
	while(low <= upper)
	{
		int mid = (low + upper) / 2;
		
		result = strcmp(input, list_probes[mid]);
		if (result == 0)
			return 1;
		else if (result < 0)
			upper = mid - 1;
		else if (result > 0)
			low = mid + 1;
	}

	return -1;
}

int loadActiveProbe()
{
	FILE *probe_file = NULL;
	int i;
	char buf[MAX_BUF];
	char *data;
	
	//printf("loadActiveProbe\n");
	//LOGI("loadActiveProbe\n");
	probe_file = fopen(PROBELIST, "r");
	if (probe_file == NULL)
	{
		LOGI("Error: Can't open [%s]", PROBELIST);
		//printf("Error: Can't open [%s]\n", PROBELIST);
		return -1;
	}
	
	//read the number of probe_items
	memset(buf, 0, sizeof(buf));
	if (fgets(buf, MAX_BUF, probe_file) != NULL)
	{
		probe_items = atoi(buf);
		if (probe_items < 0)
		{
			LOGI("Error: Get error value in number of probe_items (%d)", probe_items);
			//printf("Error: Get error value in number of probe_items (%d)\n", probe_items);
			return -1;
		}
	}
	else
	{
		LOGI("Error: Can't read number of probe_items");
		//printf("Error: Can't read number of probe_items\n");
		return -1;
	}
	list_probes = (char **)malloc(sizeof(char *) * probe_items);
	
	//store name of probes	
	for(i=0;i<probe_items;i++)
	{
		memset(buf, 0, sizeof(buf));
		if(fgets(buf, MAX_BUF, probe_file) != NULL)
		{
			int str_len;
			str_len = atoi(buf);
			if(fgets(buf, MAX_BUF, probe_file) != NULL)
			{
				data = (char *)malloc(sizeof(char) * str_len + 2);
				strncpy(data, buf, str_len);
				//data[str_len] = '\n';
				data[str_len] = '\0';
				//data[str_len + 1] = '\0';
				list_probes[i] = data;
			}
			else
			{
				LOGI("Error: Can't read name of probes");
				//printf("Error: Can't read name of probes\n");
				return -1;
			}
		}
		else
		{
			LOGI("Error: Can't read len of name");
			//printf("Error: Can't read len of name\n");
			return -1;
		}
	}

	//check
	/*for(i=0;i<probe_items;i++)
		LOGI("Index(%d):%d[%s]", i, strlen(list_probes[i]), list_probes[i]);*/
		//printf("Index(%d):%d[%s]\n", i, strlen(list_probes[i]), list_probes[i]);
	
	if (probe_file != NULL) fclose(probe_file);
		
	//LOGI("Finish load name of probes");
	//printf("Finish load name of probe\n");
	return 0;
}

void unloadActiveProbe()
{
	int i;

	//printf("unloadActiveProbe\n");
	//LOGI("unloadActiveProbe\n");
	for(i=0;i<probe_items;i++)
		free(list_probes[i]);
	free(list_probes);
	//printf("EunloadActiveProbe\n");
	//LOGI("EunloadActiveProbe\n");
}
