 #
 # Copyright (C) 2011 The Reconfigurable Multi-resolutions Profiling Project
 #
 # Licensed under the Apache License, Version 2.0 (the "License");
 # you may not use this file except in compliance with the License.
 # You may obtain a copy of the License at
 #
 #      http://www.apache.org/licenses/LICENSE-2.0
 #
 # Unless required by applicable law or agreed to in writing, software
 # distributed under the License is distributed on an "AS IS" BASIS,
 # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 # See the License for the specific language governing permissions and
 # limitations under the License.

import sys

def transferData(line):
    data = line.split()
    sec = int(data[1])
    nsec = int(data[2])
    sec = sec * 1000000000
    return sec + nsec

def isNoLog(line):
    data = line.split()
    sec = int(data[1])
    nsec = int(data[2])
    if sec == 0 and nsec == 0:
        return True
    else:
        return False  

log_1 = open(sys.argv[1], "r")  #input
log_2 = open(sys.argv[2], "r")
result = open("timeResult.txt", "w")    #output

log_1_data = []
log_2_data = []
for line in log_1:
    data = line.split()
    if data[1] == "0" and data[2] == "0":   #miss event case
        if len(log_1_data) != 0:
            log_1_data[len(log_1_data) - 1] = log_1_data[len(log_1_data) - 1].rstrip("\n") + " " + line.remove("+")
    else:
        log_1_data.append(line)

for line in log_2:
    data = line.split()
    if data[1] == "0" and data[2] == "0":
        if len(log_2_data) != 0:
            log_2_data[len(log_2_data) - 1] = log_2_data[len(log_2_data) - 1].rstrip("\n") + " " + line.strip("+")
    else:
        log_2_data.append(line)

#remove independent line
app_name_list = []
for line in log_1_data:
    data = line.split()
    if data[0].startswith("-"):
        continue
    if data[0] in app_name_list:
        app_name_list.remove(data[0])
    else:
        app_name_list.append(data[0])
        
frame_name_list = []
for line in log_2_data:
    data = line.split()
    if data[0].startswith("-"):
        continue
    elif data[0] in frame_name_list:
        frame_name_list.remove(data[0])
    else:
        frame_name_list.append(data[0])

app_count = -1      
for target in app_name_list:
    for index in range(0, len(log_1_data)):
        data = log_1_data[index].split()
        if data[0] == target:
            app_count = index
    if app_count != -1:
        log_1_data.pop(app_count)

frame_count = -1      
for target in frame_name_list:
    for index in range(0, len(log_2_data)):
        data = log_2_data[index].split()
        if data[0] == target:
            frame_count = index
    if frame_count != -1:
        log_2_data.pop(frame_count)

#start merge results
line_1 = log_1_data.pop(0)
line_2 = log_2_data.pop(0)
one_time = transferData(line_1.rstrip("\n"))
two_time = transferData(line_2.rstrip("\n"))
while(True):    #compare the time to determine which first and write to the file
    if one_time < two_time:
        result.write(line_1)
        if len(log_1_data) != 0:
            line_1 = log_1_data.pop(0)
            one_time = transferData(line_1.rstrip("\n"))
        else:
            result.write(line_2)
            break
    elif one_time > two_time:
        result.write(line_2)
        if len(log_2_data) != 0:
            line_2 = log_2_data.pop(0)
            two_time = transferData(line_2.rstrip("\n"))
        else:
            result.write(line_1)
            break
    
if len(log_1_data) != 0:
    for line in log_1_data:
        result.write(line)
elif len(log_2_data) != 0:
    for line in log_2_data:
        result.write(line)
print("Finish")
