 #
 # Copyright (C) 2011 The Reconfigurable Multi-resolutions Profiling Project
 #
 # Licensed under the Apache License, Version 2.0 (the "License");
 # you may not use this file except in compliance with the License.
 # You may obtain a copy of the License at
 #
 #      http://www.apache.org/licenses/LICENSE-2.0
 #
 # Unless required by applicable law or agreed to in writing, software
 # distributed under the License is distributed on an "AS IS" BASIS,
 # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 # See the License for the specific language governing permissions and
 # limitations under the License.

import sys

def writeActiveProbeList(list, name):
    output = open(name, 'w')
    output.write(str(len(list)) + "\n")
    for data in list:
        output.write(str(len(data)) + "\n" + data + "\n")
    

def readProbe(file_src):
    active_mod = False
    list_probes = []
    record_list = []
    
    probe_src = open(file_src, 'r')
    for line in probe_src:
        line = line.strip("\n")
        if line != "---":
            name = line.split()
            if not name[0] in record_list:
                list_probes.append(name[0])
                record_list.append(name[0])
            else:
                print("Override %s" % (name[0]))
    
    probe_src.close()
    #write the file for JNI
    probe_new = open(file_src + "_JNI", 'w')
    record_sort_list = sorted(record_list)
    
    file_name = "null"
    count = 0
    for probe_name in record_sort_list:
        index = probe_name.rindex(".")
        class_name = probe_name[0:index]
        if file_name != class_name and file_name != "null":
            count += 1
            record_sort_list.insert(record_sort_list.index(probe_name), "---")
        file_name = class_name
    print(count)
    for probe_name in record_sort_list:
        probe_new.write(probe_name + "\n")
    probe_new.close()
    return sorted(list_probes)

if __name__ == "__main__":
    if len(sys.argv) < 2:
        print("Error format: genAPlist.py <appProbesList> <frameProbesList>")
        sys.exit()
    else:
        list_app_probes = []
        list_frame_probes = []
        list_app_probes = readProbe(sys.argv[1])
        list_frame_probes = readProbe(sys.argv[2])
        #print(list_app_probes)
        #print(list_frame_probes)
        
        writeActiveProbeList(list_app_probes, "activedAppProbe")
        writeActiveProbeList(list_frame_probes, "activedFrameProbe")

        print("Finish")
