/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Copyright (C) 2011 The Reconfigurable Multi-resolutions Profiling Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package rmp;

import java.util.Vector;

public class ResultData {
	private String name;
	
	private int id;
	private int caller;
	private int no_log;
	private Vector<Integer> child;
	
	private long head_time, tail_time;
	private long exclusive_result, inclusive_result;
	private long really_ex_result, really_in_result;
	private double energy_result;
	
	public ResultData()
	{
		name = null;
		exclusive_result = 0;
		inclusive_result = 0;
		really_ex_result = 0;
		really_in_result = 0;
		head_time = 0;
		tail_time = 0;
		id = 0;
		no_log = 0;
		caller = 0;
		child = new Vector<Integer>();
		energy_result = 0.0;
	}
	
	public int getNoLog()
	{
		return this.no_log;
	}
	
	public String getName()
	{
		return this.name;
	}
	
	public long getExclusiveResult()
	{
		return this.exclusive_result;
	}
	
	public long getRealExclusiveResult()
	{
		return this.really_ex_result;
	}
	
	public long getInclusiveResult()
	{
		return this.inclusive_result;
	}
	
	public long getRealInclusiveResult()
	{
		return this.really_in_result;
	}
	
	public long getHead()
	{
		return this.head_time;
	}
	
	public long getTail()
	{
		return this.tail_time;
	}

	public double getEnergyResult()
	{
		return this.energy_result;
	}
	
	public int getID()
	{
		return this.id;
	}
	
	public int getCaller()
	{
		return this.caller;
	}
	
	public Vector<Integer> getChild()
	{
		return this.child;
	}
	
	public void setNoLog(int num)
	{
		this.no_log = num;
	}
	
	public void setName(String name)
	{
		this.name = name;
	}
	
	public void setExclusiveResult(long result)
	{
		this.exclusive_result = result;
	}
	
	public void setRealExclusiveResult(long result)
	{
		this.really_ex_result = result;
	}
	
	public void setInclusiveResult(long result)
	{
		this.inclusive_result = result;
	}
	
	public void setRealInclusiveResult(long result)
	{
		this.really_in_result = result;
	}
	
	public void setHead(long head)
	{
		this.head_time = head;
	}
	
	public void setTail(long tail)
	{
		this.tail_time = tail;
	}
	
	public void setID(int id)
	{
		this.id = id;
	}
	
	public void setCaller(int caller)
	{
		this.caller = caller;
	}
	
	public void setChild(int child)
	{
		this.child.add(child);
	}
	
	public void setEnergyResult(double energy)
	{
		this.energy_result = energy;
	}
}
