/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Copyright (C) 2011 The Reconfigurable Multi-resolutions Profiling Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package rmp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

import javax.swing.table.AbstractTableModel;

public class ProbeTableMode extends AbstractTableModel {
	String[] columnNames = {"Probe name", "Level", "Status", "Time (ns)", "Energy (uAh)", "Times"};
	private Vector<Object[]> data = new Vector<Object[]>();
	private List<String> appDataList = new ArrayList<String>();
	private List<String> frameDataList = new ArrayList<String>();

	public ProbeTableMode()
	{
		String probe_data = null;
		String[] element_probe = null;
		Boolean active = false;
		
		BufferedReader app_probes_item = null;
		BufferedReader frame_probes_item = null;
		
		// Open the probes lists
		try {
			app_probes_item = new BufferedReader(new FileReader("appProbesList"));
			frame_probes_item = new BufferedReader(new FileReader("frameProbesList"));
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		
		// Read the data from probes lists
		try {
			while((probe_data = app_probes_item.readLine()) != null)
			{
				if (probe_data.equals("---"))
					continue;
				
				element_probe = probe_data.split(" ");
				if (element_probe[2].equals("1"))
					active = true;
				else
					active = false;
				if (element_probe[1].equals("block"))
					element_probe[1] = "loop";
				Object[] temp = {element_probe[0], element_probe[1], active, Long.parseLong("0"), Double.parseDouble("0.0"), Long.parseLong("0"), "app"};
				if (sameProbe(element_probe[0]) == false)
					data.addElement(temp);
			}			
			app_probes_item.close();
			
			while((probe_data = frame_probes_item.readLine()) != null)
			{
				if (probe_data.equals("---"))
					continue;
				
				element_probe = probe_data.split(" ");
				if (element_probe[2].equals("1"))
					active = true;
				else
					active = false;
				if (element_probe[1].equals("block"))
					element_probe[1] = "loop";
				Object[] temp = {element_probe[0], element_probe[1], active, Long.parseLong("0"), Double.parseDouble("0.0"), Long.parseLong("0"), "frame"};
				if (sameProbe(element_probe[0]) == false)
					data.addElement(temp);
			}			
			frame_probes_item.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public void cleanData()
	{
		for(int i=0;i<data.size();i++)
		{
			Object[] temp = data.elementAt(i);
			temp[3] = Long.parseLong("0");
			temp[4] = Double.parseDouble("0.0");
			temp[5] = Long.parseLong("0");
		}
	}
	
	//is same probe?
	private boolean sameProbe(String new_element)
	{
		for(int i=0;i<data.size();i++)
		{
			Object[] temp = data.elementAt(i);
			if (temp[0].equals(new_element))
				return true;
		}
		return false;
	}
	
	public void setProbesLevel(String level, int first)
	{
		if (first == 0)
		{
			for (int i=0;i<data.size();i++)
			{
				if (data.get(i)[1].toString().equals(level))
					data.get(i)[2] = true;
			}
		}
		else
		{
			for (int i=0;i<data.size();i++)
			{
				if (data.get(i)[1].toString().equals(level) && Boolean.parseBoolean(data.get(i)[2].toString()) == true)
					data.get(i)[2] = true;
				else
					data.get(i)[2] = false;
			}
		}
		this.fireTableDataChanged();
	}
	
	public void setProbesTime(String cmpmode, long time, int first)
	{
		if (first == 0)
		{
			for (int i=0;i<data.size();i++)
			{
				if (cmpmode.equals(">"))
				{
					if (Long.parseLong(data.get(i)[3].toString()) > time)
						data.get(i)[2] = true;
				}
				else if (cmpmode.equals(">="))
				{
					if (Long.parseLong(data.get(i)[3].toString()) >= time)
						data.get(i)[2] = true;
				}
				else if (cmpmode.equals("<"))
				{
					if (Long.parseLong(data.get(i)[3].toString()) < time)
						data.get(i)[2] = true;
				}
				else if (cmpmode.equals("<="))
				{
					if (Long.parseLong(data.get(i)[3].toString()) <= time)
						data.get(i)[2] = true;
				}
			}
		}
		else
		{
			for (int i=0;i<data.size();i++)
			{
				if (cmpmode.equals(">"))
				{
					if (Long.parseLong(data.get(i)[3].toString()) > time && Boolean.parseBoolean(data.get(i)[2].toString()) == true)
						data.get(i)[2] = true;
					else
						data.get(i)[2] = false;
				}
				else if (cmpmode.equals(">="))
				{
					if (Long.parseLong(data.get(i)[3].toString()) >= time && Boolean.parseBoolean(data.get(i)[2].toString()) == true)
						data.get(i)[2] = true;
					else
						data.get(i)[2] = false;
				}
				else if (cmpmode.equals("<"))
				{
					if (Long.parseLong(data.get(i)[3].toString()) < time && Boolean.parseBoolean(data.get(i)[2].toString()) == true)
						data.get(i)[2] = true;
					else
						data.get(i)[2] = false;
				}
				else if (cmpmode.equals("<="))
				{
					if (Long.parseLong(data.get(i)[3].toString()) <= time && Boolean.parseBoolean(data.get(i)[2].toString()) == true)
						data.get(i)[2] = true;
					else
						data.get(i)[2] = false;
				}
			}
		}
		this.fireTableDataChanged();
	}
	
	public void setProbesTimes(String cmpmode, long times, int first)
	{
		if (first == 0)
		{
			for (int i=0;i<data.size();i++)
			{
				if (cmpmode.equals(">"))
				{
					if (Long.parseLong(data.get(i)[5].toString()) > times)
						data.get(i)[2] = true;
				}
				else if (cmpmode.equals(">="))
				{
					if (Long.parseLong(data.get(i)[5].toString()) >= times)
						data.get(i)[2] = true;
				}
				else if (cmpmode.equals("<"))
				{
					if (Long.parseLong(data.get(i)[5].toString()) < times)
						data.get(i)[2] = true;
				}
				else if (cmpmode.equals("<="))
				{
					if (Long.parseLong(data.get(i)[5].toString()) <= times)
						data.get(i)[2] = true;
				}
			}
		}
		else
		{
			for (int i=0;i<data.size();i++)
			{
				if (cmpmode.equals(">"))
				{
					if (Long.parseLong(data.get(i)[5].toString()) > times && Boolean.parseBoolean(data.get(i)[2].toString()) == true)
						data.get(i)[2] = true;
					else
						data.get(i)[2] = false;
				}
				else if (cmpmode.equals(">="))
				{
					if (Long.parseLong(data.get(i)[5].toString()) >= times && Boolean.parseBoolean(data.get(i)[2].toString()) == true)
						data.get(i)[2] = true;
					else
						data.get(i)[2] = false;
				}
				else if (cmpmode.equals("<"))
				{
					if (Long.parseLong(data.get(i)[5].toString()) < times && Boolean.parseBoolean(data.get(i)[2].toString()) == true)
						data.get(i)[2] = true;
					else
						data.get(i)[2] = false;
				}
				else if (cmpmode.equals("<="))
				{
					if (Long.parseLong(data.get(i)[5].toString()) <= times && Boolean.parseBoolean(data.get(i)[2].toString()) == true)
						data.get(i)[2] = true;
					else
						data.get(i)[2] = false;
				}
			}
		}
		this.fireTableDataChanged();
	}

	public boolean setTimeResult(ResultData resultdata, Vector<String> childName, Vector<String> InChildName)
	{
		int app = 0, inclusive_app = 0, frame = 0, inclusive_frame = 0;
		
		//For exclusive
		for (int i=0;i<data.size();i++)
		{
			for (int j=0;j<childName.size();j++)
			{
				if (this.getValueAt(i, 0).toString().equals(childName.elementAt(j)))
				{
					if (this.getValueAt(i, 6).toString().equals("app"))
						app++;
					else
						frame++;
				}
			}
		}
		
		//For inclusive
		for (int i=0;i<data.size();i++)
		{
			for (int j=0;j<InChildName.size();j++)
			{
				if (this.getValueAt(i, 0).toString().equals(InChildName.elementAt(j)))
				{
					if (this.getValueAt(i, 6).toString().equals("app"))
						inclusive_app++;
					else
						inclusive_frame++;
				}
			}
		}

		for (int i=0;i<data.size();i++)
		{
			if (this.getValueAt(i, 0).toString().equals(resultdata.getName()))
			{
				resultdata.setRealInclusiveResult(resultdata.getRealInclusiveResult() - (488281 * inclusive_app) - (630697 * inclusive_frame));
				
				if (Long.parseLong(this.getValueAt(i, 5).toString()) == 0)
				{
					//minus overhead
					long minus_result = resultdata.getRealExclusiveResult() - (488281 * app) - (630697 * frame);
					if (minus_result <= 0)
					{
						this.setValueAt((long)0, i, 3);
						resultdata.setRealExclusiveResult(0);
					}	
					else
					{
						this.setValueAt(minus_result, i, 3);
						resultdata.setRealExclusiveResult(minus_result);
					}
					this.setValueAt(Long.parseLong(this.getValueAt(i, 5).toString()) + 1, i, 5);
				}
				else
				{
					//minus overhead
					long minus_result = resultdata.getRealExclusiveResult() - (488281 * app) - (630697 * frame);
					long new_time = 0;
					if (minus_result > 0)
					{
						new_time = (Long.parseLong(this.getValueAt(i, 3).toString()) + minus_result);
						resultdata.setRealExclusiveResult(minus_result);
					}
					else
						resultdata.setRealExclusiveResult(0);
					this.setValueAt(new_time, i, 3);
					this.setValueAt(Long.parseLong(this.getValueAt(i, 5).toString()) + 1, i, 5);
				}
				return true;
			}
		}
		
		return false;
	}
	
	public void calTimeAvg()
	{
		for (int i=0;i<data.size();i++)
		{
			int times = Integer.parseInt(this.getValueAt(i, 5).toString());
			long sum_time = Long.parseLong(this.getValueAt(i, 3).toString());

			if (times != 0 && sum_time != 0)
				this.setValueAt((sum_time / times), i, 3);
		}
	}
	
	public boolean setEnergyResult(ResultData resultdata)
	{
		for (int i=0;i<data.size();i++)
		{
			if (this.getValueAt(i, 0).toString().equals(resultdata.getName()))
			{
				if (Double.parseDouble(this.getValueAt(i, 4).toString()) == 0)
					this.setValueAt(resultdata.getEnergyResult(), i, 4);
				else
				{
					double new_energy = (Double.parseDouble(this.getValueAt(i, 4).toString()) + resultdata.getEnergyResult());
					this.setValueAt(new_energy, i, 4);
				}

				return true;
			}
		}
		
		return false;
	}
	
	public void calEnergyAvg()
	{
		for (int i=0;i<data.size();i++)
		{
			int times = Integer.parseInt(this.getValueAt(i, 5).toString());
			double sum_energy = Double.parseDouble(this.getValueAt(i, 4).toString());
			if (times != 0 && sum_energy != 0)
				this.setValueAt((sum_energy/times), i, 4);
		}
	}
	
	public void saveConfig()
	{
		//Select activated probes
		for(int i=0;i<data.size();i++)
		{
			if (data.get(i)[2] == (Object)true)
				if (data.get(i)[6].toString().equals("app"))
					appDataList.add(data.get(i)[0].toString());
				else
					frameDataList.add(data.get(i)[0].toString());
		}
		//Sort
		Collections.sort(appDataList);
		Collections.sort(frameDataList);
		
		BufferedWriter appWriter = null;
		BufferedWriter frameWriter = null;
		
		//Store in config files
		try {
			appWriter = new BufferedWriter(new FileWriter("activedAppProbe"));
			frameWriter = new BufferedWriter(new FileWriter("activedFrameProbe"));
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		try {
			appWriter.write(String.valueOf(appDataList.size()));
			appWriter.newLine();
			for(int i=0;i<appDataList.size();i++)
			{
				appWriter.write(String.valueOf(appDataList.get(i).length()));
				appWriter.newLine();
				appWriter.write(appDataList.get(i));
				appWriter.newLine();
			}
			appWriter.close();
			
			frameWriter.write(String.valueOf(frameDataList.size()));
			frameWriter.newLine();
			for(int i=0;i<frameDataList.size();i++)
			{
				frameWriter.write(String.valueOf(frameDataList.get(i).length()));
				frameWriter.newLine();
				frameWriter.write(frameDataList.get(i));
				frameWriter.newLine();
			}
			frameWriter.close();
		} catch (IOException e) {
			e.printStackTrace();
		}	
	}
	
	public boolean isApp(String name)
	{
		for (int i=0;i<data.size();i++)
		{
			if (this.getValueAt(i, 0).toString().equals(name))
			{
				if (this.getValueAt(i, 6).toString().equals("app"))
					return true;
				else
					return false;
			}
		}
		return false;
	}
	
	public void cleanSelect()
	{
		for (int i=0;i<data.size();i++)
		{
			if (Boolean.parseBoolean(this.getValueAt(i, 2).toString()) == true)
			{
				this.setValueAt(false, i, 2);
			}
		}
	}
	
	public int getColumnCount() {
		return columnNames.length;
	}
	
	public int getRowCount() {
		return data.size();
	}
	
	public String getColumnName(int col) {
		return columnNames[col];
	}
	
	public Object getValueAt(int row, int col) {
		Object[] temp = data.get(row);
		return temp[col];
	}
	
	public void setValueAt(Object value, int row, int col) {
		Object[] temp = data.get(row);
        temp[col] = value;
        data.set(row, temp);
        fireTableCellUpdated(row, col);
    }
	
	public Class getColumnClass(int c) {
        return getValueAt(0, c).getClass();
    }
	
	public boolean isCellEditable(int row, int col) {
        if (col < 2) {
            return false;
        } else {
            return true;
        }
    }
}
