/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Copyright (C) 2011 The Reconfigurable Multi-resolutions Profiling Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package rmp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class LogSpace {
	private int log_space;
	
	public LogSpace()
	{
		BufferedReader size_file = null;
		
		try {
			size_file = new BufferedReader(new FileReader("logsize"));
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		
		try {
			log_space = Integer.parseInt(size_file.readLine());
		} catch (NumberFormatException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public int getLogSpace()
	{
		return this.log_space;
	}
	
	public void setLogSpace(int newsize)
	{
		this.log_space = newsize;
	}
	
	public void saveConfig()
	{
		BufferedWriter logspaceWriter = null;
		
		try {
			logspaceWriter = new BufferedWriter(new FileWriter("logsize"));
			logspaceWriter.write(String.valueOf(this.log_space));
			logspaceWriter.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
