/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Copyright (C) 2011 The Reconfigurable Multi-resolutions Profiling Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package rmp;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.JButton;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

/**
* This code was edited or generated using CloudGarden's Jigloo
* SWT/Swing GUI Builder, which is free for non-commercial
* use. If Jigloo is being used commercially (ie, by a corporation,
* company or business for any purpose whatever) then you
* should purchase a license for each developer using Jigloo.
* Please visit www.cloudgarden.com for details.
* Use of Jigloo implies acceptance of these licensing terms.
* A COMMERCIAL LICENSE HAS NOT BEEN PURCHASED FOR
* THIS MACHINE, SO JIGLOO OR THIS CODE CANNOT BE USED
* LEGALLY FOR ANY CORPORATE OR COMMERCIAL PURPOSE.
*/
public class InfDialog extends javax.swing.JDialog {
	private JScrollPane infScrollPane;
	private JTextPane infTextPane;
	private JButton closeButton;
	private JScrollPane ScrollPane;
	private JPanel infPanel;
	
	private ResultDatabase data;
	private String name;

	public InfDialog(JFrame frame, ResultDatabase resultData, String name) {
		super(frame);
		this.data = resultData;
		this.name = name;
		initGUI();
	}
	
	public void setName(String name)
	{
		this.name = name;
		if (!this.name.equals("null"))
			update();
	}
	
	public void update()
	{	//show results in dialog
		Vector<ResultData> result = data.getDatas(this.name);
		StringBuffer content = new StringBuffer();
		content.append("Probe name: ").append(this.name).append("\n");
		content.append("Called times: ").append(result.size()).append("\n");
		content.append("---------------------------------------------------\n");
		for(int i=0;i<result.size();i++)
		{
			content.append("#").append(i).append("\n");
			content.append("Exclusive time result: ").append(result.get(i).getExclusiveResult()).append(" ns\n");
			content.append("Inclusive time result: ").append(result.get(i).getInclusiveResult()).append(" ns\n");
			content.append("Real Exclusive time result: ").append(result.get(i).getRealExclusiveResult()).append(" ns\n");
			content.append("Real Inclusive time result: ").append(result.get(i).getRealInclusiveResult()).append(" ns\n");
			content.append("Energy result: ").append(result.get(i).getEnergyResult()).append(" uAh\n");
			ResultData caller_data = this.data.getData(result.get(i).getCaller());
			if (caller_data != null)
				content.append("Caller: ").append(caller_data.getName()).append("\n");
			content.append("Child: \n");
			for(int j=0;j<result.get(i).getChild().size();j++)
				content.append("\t").append(this.data.getData(result.get(i).getChild().get(j)).getName()).append("\n");
			content.append("---------------------------------------------------\n");
		}
		
		this.infTextPane.setText(content.toString());
	}
	
	private void initGUI() {
		try {
			{
				infScrollPane = new JScrollPane();
				getContentPane().add(infScrollPane, BorderLayout.NORTH);
			}
			{
				infPanel = new JPanel();
				getContentPane().add(infPanel, BorderLayout.CENTER);
				infPanel.setLayout(null);
				infPanel.setPreferredSize(new java.awt.Dimension(359, 286));
				{
					ScrollPane = new JScrollPane();
					infPanel.add(ScrollPane);
					ScrollPane.setBounds(0, 0, 359, 259);
					{
						infTextPane = new JTextPane();
						ScrollPane.setViewportView(infTextPane);
						infTextPane.setText("null");
					}
				}
				{
					closeButton = new JButton();
					infPanel.add(closeButton);
					closeButton.setText("Close");
					closeButton.setBounds(147, 271, 81, 35);
					closeButton.addActionListener(new ActionListener()
					{
						@Override
						public void actionPerformed(ActionEvent arg0) {
							dispose();					
						}							
					});
				}
			}
			this.setSize(375, 358);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
