/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Copyright (C) 2011 The Reconfigurable Multi-resolutions Profiling Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package rmp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

import javax.swing.table.AbstractTableModel;

public class FrameCallerTableMode extends AbstractTableModel {
	String[] columnNames = {"Frame caller name"};
	private Vector<String> data = new Vector<String>();
	
	public FrameCallerTableMode()
	{
		int caller_num;
		String caller_name = null;
		
		BufferedReader caller_item = null;
		
		
		try {
			caller_item = new BufferedReader(new FileReader("framecallerconf"));
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		
		try {
			caller_num = Integer.parseInt(caller_item.readLine());
			for(int i=0;i<caller_num;i++)
			{
				caller_item.readLine();
				caller_name = caller_item.readLine();
				data.addElement(caller_name);
			}			
			caller_item.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public void saveConfig()
	{
		BufferedWriter appCallerWriter = null;
		
		try {
			appCallerWriter = new BufferedWriter(new FileWriter("framecallerconf"));
			appCallerWriter.write(String.valueOf(data.size()));
			appCallerWriter.newLine();
			for(int i=0;i<data.size();i++)
			{
				appCallerWriter.write(String.valueOf(data.get(i).length()));
				appCallerWriter.newLine();
				appCallerWriter.write(data.get(i));
				appCallerWriter.newLine();
			}
			appCallerWriter.close();
		} catch (IOException e) {
			e.printStackTrace();
		}	
	}
	
	public void addValue(String name)
	{
		for(int i=0;i<data.size();i++)
			if (data.get(i).equals(name))
				return;
		
		data.addElement(name);
		this.fireTableDataChanged();
	}
	
	public void removeValue(String name)
	{
		for(int i=0;i<data.size();i++)
			if (data.get(i).equals(name))
			{
				data.remove(i);
				break;
			}
		this.fireTableDataChanged();
	}
	
	public int getColumnCount() {
		return columnNames.length;
	}
	
	public int getRowCount() {
		return data.size();
	}
	
	public String getColumnName(int col) {
		return columnNames[col];
	}
	
	public String getValueAt(int row, int col) {
		if (data.size() < 1)
			return "null";
		String temp = data.get(row);
		return temp;
	}
	
	public void setValueAt(Object value, int row, int col) {
        data.set(row, value.toString());
        fireTableCellUpdated(row, col);
    }
	
	public Class getColumnClass(int c) {
        return getValueAt(0, c).getClass();
    }
}
