/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Copyright (C) 2011 The Reconfigurable Multi-resolutions Profiling Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package rmp;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.JButton;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;

/**
* This code was edited or generated using CloudGarden's Jigloo
* SWT/Swing GUI Builder, which is free for non-commercial
* use. If Jigloo is being used commercially (ie, by a corporation,
* company or business for any purpose whatever) then you
* should purchase a license for each developer using Jigloo.
* Please visit www.cloudgarden.com for details.
* Use of Jigloo implies acceptance of these licensing terms.
* A COMMERCIAL LICENSE HAS NOT BEEN PURCHASED FOR
* THIS MACHINE, SO JIGLOO OR THIS CODE CANNOT BE USED
* LEGALLY FOR ANY CORPORATE OR COMMERCIAL PURPOSE.
*/
public class CallGraphDialog extends javax.swing.JDialog {
	private JScrollPane infScrollPane;
	private JTextArea callTextArea;
	private JButton closeButton;
	private JScrollPane ScrollPane;
	private JPanel infPanel;

	private ResultDatabase data;

	public CallGraphDialog(JFrame frame, ResultDatabase resultData) {
		super(frame);
		this.data = resultData;
		initGUI();
	}
	
	public void getCallGraph()
	{
		StringBuffer content = new StringBuffer();
		long head_time = -1;
		for (int i=0;i<this.data.getSize();i++)
		{
			if (this.data.getData(i).getCaller() == -1)
			{	//show block time(C/C++ lib or some miss methods)
				if (head_time != -1)
				{
					content.append("+Block (").append(this.data.getData(i).getHead() - head_time).append(" ns ");
					content.append(this.data.calBlockEnergyResult(this.data.getData(i).getHead() - head_time));
					content.append(" uAh)\n");
				}
				head_time = this.data.getData(i).getTail();
				//(each method results)
				content.append("+").append(this.data.getData(i).getName());
				content.append(" (").append(this.data.getData(i).getRealExclusiveResult()).append(" ns ");
				content.append(this.data.getData(i).getEnergyResult()).append(" uAh)\n");
				getChildName(this.data.getData(i).getChild(), content, 0);
			}
		}
		callTextArea.setText(content.toString());
	}
	
	private void getChildName(Vector<Integer> child, StringBuffer content, int level)
	{
		++level;
		
		for (int i=0;i<child.size();i++)
		{
			for (int j=0;j<level;j++)
				content.append("\t");
			content.append(this.data.getData(child.get(i)).getName());
			content.append(" (");
			content.append(this.data.getData(child.get(i)).getRealExclusiveResult());
			content.append(" ns ");
			content.append(this.data.getData(child.get(i)).getEnergyResult());
			content.append(" uAh)\n");
			getChildName(this.data.getData(child.get(i)).getChild(), content, level);
		}
	}
	
	private void initGUI() {
		try {
			{
				infScrollPane = new JScrollPane();
				getContentPane().add(infScrollPane, BorderLayout.NORTH);
			}
			{
				infPanel = new JPanel();
				getContentPane().add(infPanel, BorderLayout.CENTER);
				infPanel.setLayout(null);
				infPanel.setPreferredSize(new java.awt.Dimension(531, 475));
				{
					ScrollPane = new JScrollPane();
					infPanel.add(ScrollPane);
					ScrollPane.setBounds(0, 0, 468, 467);
					{
						callTextArea = new JTextArea();
						ScrollPane.setViewportView(callTextArea);
					}
				}
				{
					closeButton = new JButton();
					infPanel.add(closeButton);
					closeButton.setText("Close");
					closeButton.setBounds(189, 473, 81, 35);
					closeButton.addActionListener(new ActionListener()
					{
						@Override
						public void actionPerformed(ActionEvent arg0) {
							dispose();					
						}							
					});
				}
			}
			this.setSize(484, 556);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
