/*
 * Copyright (C) 2011 The Reconfigurable Multi-resolutions Profiling Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "caller.h"

int caller_items;
char **list_caller;
struct reg_node **list_reg;

int isUnRegCaller(const char *name)
{
	int i;
	
	//LOGI("%s at isUnRegCaller\n", name);
	
	if(caller_items == 0)
		return 1;
	
	for(i = 0;i<caller_items;i++)
	{
		if(list_reg[i] != NULL)
		{
			if(strcmp(name, list_reg[i]->name) == 0)
			{
				struct reg_node *temp = list_reg[i]->next;
				free(list_reg[i]);
				list_reg[i] = temp;
				return 1;
			}
		}
	}

	return -1;
}

int isRegCaller(const char *caller, const char *name)
{
	int i;
	
	//LOGI("[%s] [%s] at isRegCaller\n", caller, name);
	
	if(caller_items == 0)
		return 1;
	
	//is start point?
	for(i = 0;i<caller_items;i++)
	{
		if(strcmp(name, list_caller[i]) == 0)
			return 1;
	}
	
	for(i = 0;i<caller_items;i++)
	{
		if(list_reg[i] != NULL)
		{
			if(strcmp(caller, list_reg[i]->name) == 0)
			{
				struct reg_node *newreg = (struct reg_node *)malloc(sizeof(struct reg_node));
				newreg->name = (char *)malloc(sizeof(char) * strlen(name) + 1);
				newreg->next = NULL;
				strcpy(newreg->name, name);
				newreg->next = list_reg[i];
				list_reg[i] = newreg;
				return 1;
			}
		}
		else
		{
			if(strcmp(caller, list_caller[i]) == 0)
			{
				struct reg_node *newreg = (struct reg_node *)malloc(sizeof(struct reg_node));
				newreg->name = (char *)malloc(sizeof(char) * strlen(name) + 1);
				newreg->next = NULL;
				strcpy(newreg->name, name);
				list_reg[i] = newreg;
				return 1;
			}
		}
	}
	
	return -1;
}

int loadCaller()
{
	FILE *caller_file = NULL;
	int i;
	char buf[MAX_BUF];
	char *data;
	
	//LOGI("loadCaller\n");
	caller_file = fopen(CALLERCONFIG, "r");
	if (caller_file == NULL)
	{
		LOGI("Error: Can't open [%s]", CALLERCONFIG);
		return -1;
	}
	
	//read the number of caller_items
	memset(buf, 0, sizeof(buf));
	if (fgets(buf, MAX_BUF, caller_file) != NULL)
	{
		caller_items = atoi(buf);
		if (caller_items < 0)
		{
			LOGI("Error: Get error value in number of caller_items (%d)", caller_items);
			return -1;
		}
	}
	else
	{
		LOGI("Error: Can't read number of caller_items");
		return -1;
	}
	list_caller = (char **)malloc(sizeof(char *) * caller_items);
	list_reg = (struct reg_node **)malloc(sizeof(struct reg_node *) * caller_items);
	
	//store name of probes	
	for(i=0;i<caller_items;i++)
	{
		memset(buf, 0, sizeof(buf));
		if(fgets(buf, MAX_BUF, caller_file) != NULL)
		{
			int str_len;
			str_len = atoi(buf);
			if(fgets(buf, MAX_BUF, caller_file) != NULL)
			{
				data = (char *)malloc(sizeof(char) * str_len + 1);
				strncpy(data, buf, str_len);
				data[str_len] = '\0';
				list_caller[i] = data;
				
				list_reg[i] = NULL;
			}
			else
			{
				LOGI("Error: Can't read name of caller");
				return -1;
			}
		}
		else
		{
			LOGI("Error: Can't read len of name");
			return -1;
		}
	}

	//check
	/*for(i=0;i<caller_items;i++)
		LOGI("Index(%d):%d[%s]", i, strlen(list_caller[i]), list_caller[i]);*/
	
	if (caller_file != NULL) fclose(caller_file);
		
	//LOGI("Finish load name of caller");
	return 0;
}

void unloadCaller()
{
	int i;
	struct reg_node *temp;

	//LOGI("unloadCaller\n");
	for(i=0;i<caller_items;i++)
	{
		free(list_caller[i]);
		while(list_reg[i] != NULL)
		{
			temp = list_reg[i]->next;
			free(list_reg[i]->name);
			free(list_reg[i]);
			list_reg[i] = temp;
		}
	}
	free(list_caller);
	free(list_reg);
	//LOGI("EunloadCaller\n");
}