//----------------------------------------------------------------------------------
// File:            apps\jniperftest\src\com\nvidia\devtech\jniperftest\JNIPerfTest.java
// Samples Version: Android NVIDIA samples 2 
// Email:           tegradev@nvidia.com
// Forum:           http://developer.nvidia.com/tegra/forums/tegra-forums/android-development
//
// Copyright 2009-2010 NVIDIACorporation 
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//----------------------------------------------------------------------------------

package com.nvidia.devtech.jniperftest;

import android.app.Activity;
import android.os.Bundle;

public class JNIPerfTest
	extends Activity
{
    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
		/*initTests();
        test0();
        initTests();
        test0_0();
		initTests();
        test1();
		initTests();
        test2();*/
		initTests();
        test3();
		initTests();
        test4();
		/*initTests();
        test5();
		initTests();
        test6();
		initTests();
        test7();*/
        /*initTests();
        test8();
        initTests();
        test9();*/
        //initTests();
        //test10();
        finish();
    }
    
    public native void initTests();

    // ======================================================================
    //	Only call java function
    // ======================================================================

    int test0 = 0;
    public int javaTest0()
    {
    	return test0++; 
    }
    public void test0()
    {
    	System.out.println("Test 0: calling a java function in a loop 10,000times");
    	//StackTraceElement[] strace = Thread.currentThread().getStackTrace();
    	long start = System.currentTimeMillis();
    	//String.format("%s.%s", strace[3].getClassName(), strace[3].getMethodName());
        for (int i = 0; i < 10000; i++)
        {
        	javaTest0();
        	//String.format("%s.%s", strace[3].getClassName(), strace[3].getMethodName());
        	//StackTraceElement[] strace = Thread.currentThread().getStackTrace();
        }
        long end = System.currentTimeMillis();
        int count = javaTest0();

        System.out.println("- Total time in milliseconds: " + (end-start) + ", microseconds per iteration: " + ((end - start) / (10000.0f)));
        if (count != 10000)
        	System.out.println("ERROR, count is not what is expected!");
    }

    // ======================================================================
    //	only call JNI
    // ======================================================================

    public void test0_0()
    {
    	System.out.println("Test 0_0: calling a JNI function in a loop 10,000times");
        long start = System.currentTimeMillis();
        for (int i = 0; i < 10000; i++)
        {
        	ntest0();
        }
        long end = System.currentTimeMillis();
        int count = ntest0();

        System.out.println("- Total time in milliseconds: " + (end-start) + ", microseconds per iteration: " + ((end - start) / (10000.0f)));
        if (count != 10000)
        	System.out.println("ERROR, count is not what is expected!");

    }
    public native int ntest0();

    // ======================================================================
    //	send stack inf
    // ======================================================================
    
    public void test1()
    {
    	System.out.println("Test 1: calling a JNI function in a loop 10,000times");
    	StackTraceElement[] strace = Thread.currentThread().getStackTrace();
        long start = System.currentTimeMillis();
        for (int i = 0; i < 10000; i++)
        {
        	ntest1("com.android.demo.test.aaa", true, String.format("%s.%s", strace[3].getClassName(), strace[3].getMethodName()), true);
        }
        long end = System.currentTimeMillis();
        int count = ntest1("com.android.demo.test.aaa", true, String.format("%s.%s", strace[3].getClassName(), strace[3].getMethodName()), true);

        System.out.println("- Total time in milliseconds: " + (end-start) + ", microseconds per iteration: " + ((end - start) / (10000.0f)));
        if (count != 10000)
        	System.out.println("ERROR, count is not what is expected!");

    }
    public native int ntest1(String name, boolean type, String caller, boolean reg);

    // ======================================================================
    //	just send null, no stack
    // ======================================================================
    public void test2()
    {
    	System.out.println("Test 2: calling a JNI function in a loop 10,000times");
    	StackTraceElement[] strace = Thread.currentThread().getStackTrace();
        long start = System.currentTimeMillis();
        for (int i = 0; i < 10000; i++)
        {
        	ntest2("com.android.demo.test.bbb", true, "null", true);
        }
        long end = System.currentTimeMillis();
        int count = ntest2("com.android.demo.test.bbb", true, "null", true);

        System.out.println("- Total time in milliseconds: " + (end-start) + ", microseconds per iteration: " + ((end - start) / (10000.0f)));
        if (count != 10000)
        	System.out.println("ERROR, count is not what is expected!");

    }
    public native int ntest2(String name, boolean type, String caller, boolean reg);
    
    // ======================================================================
    //	Not log with stack
    // ======================================================================
    public void test3()
    {
    	System.out.println("Test 3: calling a JNI function in a loop 10,000times");
    	String caller = Thread.currentThread().getCaller();
        //long start = System.currentTimeMillis();
        for (int i = 0; i < 10; i++)
        {
        	long start = System.nanoTime();
        	ntest3("com.android.browser.AddNewBookmark.setUrl", true, caller, true);
        	long end = System.nanoTime();
        	System.out.println("Time: " + (end-start));
        }
        //long end = System.currentTimeMillis();

        //System.out.println("- Total time in milliseconds: " + (end-start) + ", microseconds per iteration: " + ((end - start) / (10000.0f)));

    }
    public native int ntest3(String name, boolean type, String caller, boolean reg);
    
    // ======================================================================
    //	Log with stack
    // ======================================================================
    public void test4()
    {
    	System.out.println("Test 4: calling a JNI function in a loop 10,000times");
    	String caller = Thread.currentThread().getCaller();
        //long start = System.currentTimeMillis();
        for (int i = 0; i < 10; i++)
        {
        	//ntest4("com.android.browser.AddNewBookmark.setUrl", true, String.format("%s.%s", strace[3].getClassName(), strace[3].getMethodName()), true);
        	//ntest4("com.android.browser.AddNewBookmark.setUrl", true, caller, true);
        	long start = System.nanoTime();
        	ntest4("com.demo.android.test.TestThread.yyyyyyyyyyy", true, caller, true);
        	long end = System.nanoTime();
        	System.out.println("Time: " + (end-start));
        }
        //long end = System.currentTimeMillis();
        //int count = ntest4("com.android.browser.AddNewBookmark.setUrl", true, String.format("%s.%s", strace[3].getClassName(), strace[3].getMethodName()), true);
        //int count = ntest4("com.android.browser.AddNewBookmark.setUrl", true, caller, true);

        //System.out.println("- Total time in milliseconds: " + (end-start) + ", microseconds per iteration: " + ((end - start) / (10000.0f)));
        //if (count != 10000)
        //	System.out.println("ERROR, count is not what is expected!");

    }
    public native int ntest4(String name, boolean type, String caller, boolean reg);

    // ======================================================================
    // ======================================================================
    int test5 = 0;
    public int javaTest5()
    {
    	return test5++;
    }
    public void test5()
    {
    	System.out.println("Test 5: calling a JNI function that calls a Java function in a loop 1 000 000 times");

    	long start = System.currentTimeMillis();
        int count = nativeTest5();
        long end = System.currentTimeMillis();

        System.out.println("- Total time in milliseconds: " + (end-start) + ", microseconds per iteration: " + ((end - start) / (1000.0f)));
        if (count != 1000000)
        	System.out.println("ERROR, count is not what is expected!");
    }
    public native int nativeTest5();

    // ======================================================================
    // ======================================================================
    public void test6()
    {
    	System.out.println("Test 6: calling a JNI function that reads an entry from a Java array in a loop 1 000 000 times");
    	int testArray[] = new int[1024];
    	for (int i = 0; i < testArray.length; i++)
    	{
    		testArray[i] = i;
    	}
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; i++)
        {
        	nativeTest6(testArray, i & 1023);
        }
        long end = System.currentTimeMillis();
        int count = nativeTest6(testArray, 1000);

        System.out.println("- Total time in milliseconds: " + (end-start) + ", microseconds per iteration: " + ((end - start) / (1000.0f)));
        if (count != 1000000)
        	System.out.println("ERROR, count is not what is expected!");
    }
    public native int nativeTest6(int[] testArray, int count);

    // ======================================================================
    // ======================================================================
    public void test7()
    {
    	System.out.println("Test 7: calling a JNI function that sets an entry in a Java array in a loop 1 000 000 times");

    	int testArray[] = new int[1024];
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; i++)
        {
        	nativeTest7(testArray, i & 1023);
        }
        long end = System.currentTimeMillis();
        int count = nativeTest7(testArray, 1000);

    	for (int i = 0; i < testArray.length; i++)
    	{
    		if (testArray[i] != i)
    		{
    			System.out.println("ERROR!!! Array content doesn't match expected value");
    		}
    	}

    	System.out.println("- Total time in milliseconds: " + (end-start) + ", microseconds per iteration: " + ((end - start) / (1000.0f)));
        if (count != 1000000)
        	System.out.println("ERROR, count is not what is expected!");
    }
    public native int nativeTest7(int[] testArray, int count);
    // ======================================================================
    // ======================================================================
    
    public void test8()
    {
    	System.out.println("Test 8");

        long start = System.currentTimeMillis();
        for (int i = 0; i < 10000; i++)
        {
        	ntest8();
        }
        long end = System.currentTimeMillis();

    	System.out.println("- Total time in milliseconds: " + (end-start) + ", microseconds per iteration: " + ((end - start) / (10000.0f)));
    }
    public native void ntest8();
    // ======================================================================
    // ======================================================================
    
    public void nativeTest9()
    {
    	int i;
    	int a = 0;
    	for(i=0;i<10000;i++)
    	{
    		a++;
    	}
    }
    
    public void test9()
    {
    	System.out.println("Test 9");

        long start = System.currentTimeMillis();
        for (int i = 0; i < 10000; i++)
        {
        	nativeTest9();
        }
        long end = System.currentTimeMillis();

    	System.out.println("- Total time in milliseconds: " + (end-start) + ", microseconds per iteration: " + ((end - start) / (10000.0f)));
    }
    // ======================================================================
    // ======================================================================
    
    public void test10()
    {
    	System.out.println("Test 10");

    	String caller = Thread.currentThread().getCaller();
        long start = System.currentTimeMillis();
        for (int i = 0; i < 10000; i++)
        {
        	ntest10("com.android.browser.AddNewBookmark.setUrl", true, caller, true);
        }
        long end = System.currentTimeMillis();

    	System.out.println("- Total time in milliseconds: " + (end-start) + ", microseconds per iteration: " + ((end - start) / (10000.0f)));
    }
    
    public native int ntest10(String name, boolean type, String caller, boolean reg);
    // ======================================================================
    // ======================================================================
    
    static {
        System.loadLibrary("jniperftest");
    }
}