#include "logsys.h"

FILE *output = NULL;
int max_size, pos;
struct logdata *list_data;

int activeLog(const char *name)
//int activeLog(char *name)
{
	//printf("activeLog\n");
	//LOGI("activeLog\n");
	if(pos == max_size)
	{
		int result = cleanLogList();
		if(result == -1)
			return -1;
	}

	list_data[pos].name = (char *)malloc(sizeof(char) * strlen(name) + 1);
	strcpy(list_data[pos].name, name);
	clock_gettime(CLOCK_MONOTONIC, &(list_data[pos].now));
	pos++;
	
	//printf("EactiveLog\n");
	//LOGI("EactiveLog\n");
	return 0;
}

int cleanLogList()
{
	//printf("cleanLogList\n");
	//LOGI("cleanLogList\n");
	if (pos == 0)
		return 0;
	
	int i;
	char temp[MAX_BUF];
	for(i=0;i<pos;i++)
	{
		fwrite(list_data[i].name, strlen(list_data[i].name), 1, output);
		free(list_data[i].name);
		sprintf(temp, " %ld %ld\n", list_data[i].now.tv_sec, list_data[i].now.tv_nsec);
		fwrite(temp, strlen(temp), 1, output);
	}
	pos = 0;
	fflush(output);
	//printf("EcleanLogList\n");
	//LOGI("EcleanLogList\n");
	return 0;
}

int initLogSpace(int size)
{
	//printf("initLogSpace\n");
	//LOGI("initLogSpace\n");
	pos = 0;
	max_size = size;
	list_data = (struct logdata *)malloc(sizeof(struct logdata) * size);
	
	output = fopen(LOGFILE, "w");
	if (output == NULL)
	{
		LOGI("Error: Can't open [%s]", LOGFILE);
		//printf("Error: Can't open [%s]\n", LOGFILE);
		return -1;
	}
	//printf("EinitLogSpace\n");
	//LOGI("EinitLogSpace\n");
	return 0;
}

void desLogSpace()
{
	//printf("desLogSpace\n");
	//LOGI("desLogSpace\n");
	cleanLogList();
	if (output != NULL) fclose(output);
	free(list_data);
	//printf("EdesLogSpace\n");
	//LOGI("EdesLogSpace\n");
}
