#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <pagemap/pagemap.h>

struct proc_info {
    pid_t pid;
    pm_memusage_t usage;
    unsigned long wss;
};

#define MAX_PROCS 256

static int getprocname(pid_t pid, char *buf, size_t len, char *target_name);

int main(int argc, char *argv[]) {
  pm_kernel_t *ker;
  pm_process_t *proc;
  pid_t *pids;
  struct proc_info *procs[MAX_PROCS];
  size_t num_procs;
  char cmdline[256];
  int error;

  int ws = 0;

  int i, j;

	while(1)
	{
	  error = pm_kernel_create(&ker);
	  if (error) {
	    fprintf(stderr, "Error creating kernel interface -- "
	                    "does this kernel have pagemap?\n");
	    exit(EXIT_FAILURE);
	  }
	
	  error = pm_kernel_pids(ker, &pids, &num_procs);
	  if (error) {
	    fprintf(stderr, "Error listing processes.\n");
	    exit(EXIT_FAILURE);
	  }
	
	  for (i = 0; i < num_procs; i++) {
	    procs[i] = malloc(sizeof(struct proc_info));
	    if (!procs[i]) {
	      fprintf(stderr, "malloc: %s\n", strerror(errno));
	      exit(EXIT_FAILURE);
	    }
	    procs[i]->pid = pids[i];
	    error = pm_process_create(ker, pids[i], &proc);
	    if (!error) {
	      pm_process_usage(proc, &procs[i]->usage);
	      pm_process_destroy(proc);
	    } else {
	      fprintf(stderr, "warning: could not create process interface for %d\n", pids[i]);
	      pm_memusage_zero(&procs[i]->usage);
	    }
	  }
	
	  free(pids);
	  
	  j = 0;
	  for (i = 0; i < num_procs; i++) {
	    if (procs[i]->usage.vss)
	        procs[j++] = procs[i];
	  }
	  num_procs = j;
	  
	  for (i = 0; i < num_procs; i++) {
	  	if (getprocname(procs[i]->pid, cmdline, sizeof(cmdline), argv[1]) == 0)
	  	{
		    printf("%6dK %s\n",
		        procs[i]->usage.uss / 1024,
		        cmdline
		    );
		    break;
	  	}
	  }
	}

  return 0;
}

static int getprocname(pid_t pid, char *buf, size_t len, char *target_name) {
  char filename[20];
  FILE *f;

  sprintf(filename, "/proc/%d/cmdline", pid);
  f = fopen(filename, "r");
  if (!f) { *buf = '\0'; return -1; }
  if (!fgets(buf, len, f)) { *buf = '\0'; return -1; }
  fclose(f);

  if (strcmp(buf, target_name) == 0)
  	return 0;
  else
  	return -1;
}
