/*
 * Decompiled with CFR 0.152.
 */
package info.clearthought.layout;

import info.clearthought.layout.TableLayoutConstants;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class TableLayout
implements LayoutManager2,
Serializable,
TableLayoutConstants {
    protected static final double[][] defaultSize = new double[][]{new double[0], new double[0]};
    protected static final int C = 0;
    protected static final int R = 1;
    protected static boolean checkForComponentOrientationSupport = true;
    protected static Method methodGetComponentOrientation;
    protected double[][] crSpec = new double[][]{null, null};
    protected int[][] crSize = new int[][]{null, null};
    protected int[][] crOffset = new int[][]{null, null};
    protected LinkedList list;
    protected boolean dirty;
    protected int oldWidth;
    protected int oldHeight;
    protected int hGap;
    protected int vGap;

    public TableLayout() {
        this.init(defaultSize[0], defaultSize[1]);
    }

    public TableLayout(double[][] dArray) {
        if (dArray == null || dArray.length != 2) {
            throw new IllegalArgumentException("Parameter size should be an array, a[2], where a[0] is the is an array of column widths and a[1] is an array or row heights.");
        }
        this.init(dArray[0], dArray[1]);
    }

    public TableLayout(double[] dArray, double[] dArray2) {
        this.init(dArray, dArray2);
    }

    protected void init(double[] dArray, double[] dArray2) {
        int n;
        if (dArray == null) {
            throw new IllegalArgumentException("Parameter col cannot be null");
        }
        if (dArray2 == null) {
            throw new IllegalArgumentException("Parameter row cannot be null");
        }
        this.crSpec[0] = new double[dArray.length];
        this.crSpec[1] = new double[dArray2.length];
        System.arraycopy(dArray, 0, this.crSpec[0], 0, this.crSpec[0].length);
        System.arraycopy(dArray2, 0, this.crSpec[1], 0, this.crSpec[1].length);
        for (n = 0; n < this.crSpec[0].length; ++n) {
            if (!(this.crSpec[0][n] < 0.0) || this.crSpec[0][n] == -1.0 || this.crSpec[0][n] == -2.0 || this.crSpec[0][n] == -3.0) continue;
            this.crSpec[0][n] = 0.0;
        }
        for (n = 0; n < this.crSpec[1].length; ++n) {
            if (!(this.crSpec[1][n] < 0.0) || this.crSpec[1][n] == -1.0 || this.crSpec[1][n] == -2.0 || this.crSpec[1][n] == -3.0) continue;
            this.crSpec[1][n] = 0.0;
        }
        this.list = new LinkedList();
        this.dirty = true;
    }

    public TableLayoutConstraints getConstraints(Component component) {
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.component != component) continue;
            return new TableLayoutConstraints(entry.cr1[0], entry.cr1[1], entry.cr2[0], entry.cr2[1], entry.alignment[0], entry.alignment[1]);
        }
        return null;
    }

    public void setConstraints(Component component, TableLayoutConstraints tableLayoutConstraints) {
        if (component == null) {
            throw new IllegalArgumentException("Parameter component cannot be null.");
        }
        if (tableLayoutConstraints == null) {
            throw new IllegalArgumentException("Parameter constraint cannot be null.");
        }
        ListIterator<Entry> listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.component != component) continue;
            listIterator.set(new Entry(component, tableLayoutConstraints));
        }
    }

    public void setColumn(double[] dArray) {
        this.setCr(0, dArray);
    }

    public void setRow(double[] dArray) {
        this.setCr(1, dArray);
    }

    protected void setCr(int n, double[] dArray) {
        this.crSpec[n] = new double[dArray.length];
        System.arraycopy(dArray, 0, this.crSpec[n], 0, this.crSpec[n].length);
        for (int i = 0; i < this.crSpec[n].length; ++i) {
            if (!(this.crSpec[n][i] < 0.0) || this.crSpec[n][i] == -1.0 || this.crSpec[n][i] == -2.0 || this.crSpec[n][i] == -3.0) continue;
            this.crSpec[n][i] = 0.0;
        }
        this.dirty = true;
    }

    public void setColumn(int n, double d) {
        this.setCr(0, n, d);
    }

    public void setRow(int n, double d) {
        this.setCr(1, n, d);
    }

    protected void setCr(int n, int n2, double d) {
        if (d < 0.0 && d != -1.0 && d != -2.0 && d != -3.0) {
            d = 0.0;
        }
        this.crSpec[n][n2] = d;
        this.dirty = true;
    }

    public double[] getColumn() {
        double[] dArray = new double[this.crSpec[0].length];
        System.arraycopy(this.crSpec[0], 0, dArray, 0, dArray.length);
        return dArray;
    }

    public double[] getRow() {
        double[] dArray = new double[this.crSpec[1].length];
        System.arraycopy(this.crSpec[1], 0, dArray, 0, dArray.length);
        return dArray;
    }

    public double getColumn(int n) {
        return this.crSpec[0][n];
    }

    public double getRow(int n) {
        return this.crSpec[1][n];
    }

    public int getNumColumn() {
        return this.crSpec[0].length;
    }

    public int getNumRow() {
        return this.crSpec[1].length;
    }

    public int getHGap() {
        return this.hGap;
    }

    public int getVGap() {
        return this.vGap;
    }

    public void setHGap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Parameter hGap must be non-negative.");
        }
        this.hGap = n;
    }

    public void setVGap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Parameter vGap must be non-negative.");
        }
        this.vGap = n;
    }

    public void insertColumn(int n, double d) {
        this.insertCr(0, n, d);
    }

    public void insertRow(int n, double d) {
        this.insertCr(1, n, d);
    }

    public void insertCr(int n, int n2, double d) {
        if (n2 < 0 || n2 > this.crSpec[n].length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + n2 + ".  Valid range is [0, " + this.crSpec[n].length + "].");
        }
        if (d < 0.0 && d != -1.0 && d != -2.0 && d != -3.0) {
            d = 0.0;
        }
        double[] dArray = new double[this.crSpec[n].length + 1];
        System.arraycopy(this.crSpec[n], 0, dArray, 0, n2);
        System.arraycopy(this.crSpec[n], n2, dArray, n2 + 1, this.crSpec[n].length - n2);
        dArray[n2] = d;
        this.crSpec[n] = dArray;
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.cr1[n] >= n2) {
                int n3 = n;
                entry.cr1[n3] = entry.cr1[n3] + 1;
            }
            if (entry.cr2[n] < n2) continue;
            int n4 = n;
            entry.cr2[n4] = entry.cr2[n4] + 1;
        }
        this.dirty = true;
    }

    public void deleteColumn(int n) {
        this.deleteCr(0, n);
    }

    public void deleteRow(int n) {
        this.deleteCr(1, n);
    }

    protected void deleteCr(int n, int n2) {
        if (n2 < 0 || n2 >= this.crSpec[n].length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + n2 + ".  Valid range is [0, " + (this.crSpec[n].length - 1) + "].");
        }
        double[] dArray = new double[this.crSpec[n].length - 1];
        System.arraycopy(this.crSpec[n], 0, dArray, 0, n2);
        System.arraycopy(this.crSpec[n], n2 + 1, dArray, n2, this.crSpec[n].length - n2 - 1);
        this.crSpec[n] = dArray;
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.cr1[n] > n2) {
                int n3 = n;
                entry.cr1[n3] = entry.cr1[n3] - 1;
            }
            if (entry.cr2[n] <= n2) continue;
            int n4 = n;
            entry.cr2[n4] = entry.cr2[n4] - 1;
        }
        this.dirty = true;
    }

    public String toString() {
        int n;
        String string = "TableLayout {{";
        if (this.crSpec[0].length > 0) {
            for (n = 0; n < this.crSpec[0].length - 1; ++n) {
                string = string + this.crSpec[0][n] + ", ";
            }
            string = string + this.crSpec[0][this.crSpec[0].length - 1] + "}, {";
        } else {
            string = string + "}, {";
        }
        if (this.crSpec[1].length > 0) {
            for (n = 0; n < this.crSpec[1].length - 1; ++n) {
                string = string + this.crSpec[1][n] + ", ";
            }
            string = string + this.crSpec[1][this.crSpec[1].length - 1] + "}}";
        } else {
            string = string + "}}";
        }
        return string;
    }

    public List getInvalidEntry() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        try {
            ListIterator listIterator = this.list.listIterator(0);
            while (listIterator.hasNext()) {
                Entry entry = (Entry)listIterator.next();
                if (entry.cr1[1] >= 0 && entry.cr1[0] >= 0 && entry.cr2[1] < this.crSpec[1].length && entry.cr2[0] < this.crSpec[0].length) continue;
                linkedList.add(entry.copy());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Unexpected CloneNotSupportedException");
        }
        return linkedList;
    }

    public List getOverlappingEntry() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        try {
            int n = this.list.size();
            if (n == 0) {
                return linkedList;
            }
            Entry[] entryArray = this.list.toArray(new Entry[n]);
            for (int i = 1; i < n; ++i) {
                for (int j = i - 1; j >= 0; --j) {
                    if ((entryArray[j].cr1[0] < entryArray[i].cr1[0] || entryArray[j].cr1[0] > entryArray[i].cr2[0] || entryArray[j].cr1[1] < entryArray[i].cr1[1] || entryArray[j].cr1[1] > entryArray[i].cr2[1]) && (entryArray[j].cr2[0] < entryArray[i].cr1[0] || entryArray[j].cr2[0] > entryArray[i].cr2[0] || entryArray[j].cr2[1] < entryArray[i].cr1[1] || entryArray[j].cr2[1] > entryArray[i].cr2[1])) continue;
                    linkedList.add(entryArray[j].copy());
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Unexpected CloneNotSupportedException");
        }
        return linkedList;
    }

    protected void calculateSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        int n = dimension.width - insets.left - insets.right;
        int n2 = dimension.height - insets.top - insets.bottom;
        if (this.crSpec[0].length > 0) {
            n -= this.hGap * (this.crSpec[0].length - 1);
        }
        if (this.crSpec[1].length > 0) {
            n2 -= this.vGap * (this.crSpec[1].length - 1);
        }
        this.crSize[0] = new int[this.crSpec[0].length];
        this.crSize[1] = new int[this.crSpec[1].length];
        n = this.assignAbsoluteSize(0, n);
        n2 = this.assignAbsoluteSize(1, n2);
        n = this.assignPrefMinSize(0, n, -3.0);
        n = this.assignPrefMinSize(0, n, -2.0);
        n2 = this.assignPrefMinSize(1, n2, -3.0);
        n2 = this.assignPrefMinSize(1, n2, -2.0);
        n = this.assignRelativeSize(0, n);
        n2 = this.assignRelativeSize(1, n2);
        this.assignFillSize(0, n);
        this.assignFillSize(1, n2);
        this.calculateOffset(0, insets);
        this.calculateOffset(1, insets);
        this.dirty = false;
        this.oldWidth = dimension.width;
        this.oldHeight = dimension.height;
    }

    protected int assignAbsoluteSize(int n, int n2) {
        int n3 = this.crSpec[n].length;
        for (int i = 0; i < n3; ++i) {
            if (!(this.crSpec[n][i] >= 1.0) && this.crSpec[n][i] != 0.0) continue;
            this.crSize[n][i] = (int)(this.crSpec[n][i] + 0.5);
            n2 -= this.crSize[n][i];
        }
        return n2;
    }

    protected int assignRelativeSize(int n, int n2) {
        int n3 = n2 < 0 ? 0 : n2;
        int n4 = this.crSpec[n].length;
        for (int i = 0; i < n4; ++i) {
            if (!(this.crSpec[n][i] > 0.0) || !(this.crSpec[n][i] < 1.0)) continue;
            this.crSize[n][i] = (int)(this.crSpec[n][i] * (double)n3 + 0.5);
            n2 -= this.crSize[n][i];
        }
        return n2;
    }

    protected void assignFillSize(int n, int n2) {
        int n3;
        int n4;
        if (n2 <= 0) {
            return;
        }
        int n5 = 0;
        int n6 = this.crSpec[n].length;
        for (n4 = 0; n4 < n6; ++n4) {
            if (this.crSpec[n][n4] != -1.0) continue;
            ++n5;
        }
        n4 = n2;
        for (n3 = 0; n3 < n6; ++n3) {
            if (this.crSpec[n][n3] != -1.0) continue;
            this.crSize[n][n3] = n2 / n5;
            n4 -= this.crSize[n][n3];
        }
        for (n3 = n6 - 1; n3 >= 0 && n4 > 0; --n3) {
            if (this.crSpec[n][n3] != -1.0) continue;
            int[] nArray = this.crSize[n];
            int n7 = n3;
            nArray[n7] = nArray[n7] + 1;
            --n4;
        }
    }

    protected void calculateOffset(int n, Insets insets) {
        int n2 = this.crSpec[n].length;
        this.crOffset[n] = new int[n2 + 1];
        this.crOffset[n][0] = n == 0 ? insets.left : insets.top;
        for (int i = 0; i < n2; ++i) {
            this.crOffset[n][i + 1] = this.crOffset[n][i] + this.crSize[n][i];
        }
    }

    protected int assignPrefMinSize(int n, int n2, double d) {
        int n3 = this.crSpec[n].length;
        for (int i = 0; i < n3; ++i) {
            if (this.crSpec[n][i] != d) continue;
            int n4 = 0;
            ListIterator listIterator = this.list.listIterator(0);
            block1: while (listIterator.hasNext()) {
                int n5;
                Dimension dimension;
                Entry entry = (Entry)listIterator.next();
                if (entry.cr1[n] < 0 || entry.cr2[n] >= n3 || entry.cr1[n] > i || entry.cr2[n] < i) continue;
                Dimension dimension2 = dimension = d == -2.0 ? entry.component.getPreferredSize() : entry.component.getMinimumSize();
                int n6 = dimension == null ? 0 : (n == 0 ? dimension.width : dimension.height);
                int n7 = 0;
                if (d == -2.0) {
                    for (n5 = entry.cr1[n]; n5 <= entry.cr2[n]; ++n5) {
                        if (this.crSpec[n][n5] >= 0.0 || this.crSpec[n][n5] == -3.0) {
                            n6 -= this.crSize[n][n5];
                            continue;
                        }
                        if (this.crSpec[n][n5] == -2.0) {
                            ++n7;
                            continue;
                        }
                        if (this.crSpec[n][n5] == -1.0) continue block1;
                    }
                } else {
                    for (n5 = entry.cr1[n]; n5 <= entry.cr2[n]; ++n5) {
                        if (this.crSpec[n][n5] >= 0.0) {
                            n6 -= this.crSize[n][n5];
                            continue;
                        }
                        if (this.crSpec[n][n5] == -2.0 || this.crSpec[n][n5] == -3.0) {
                            ++n7;
                            continue;
                        }
                        if (this.crSpec[n][n5] == -1.0) continue block1;
                    }
                }
                if (n4 >= (n6 = (int)Math.ceil((double)n6 / (double)n7))) continue;
                n4 = n6;
            }
            this.crSize[n][i] = n4;
            n2 -= n4;
        }
        return n2;
    }

    public void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        if (this.dirty || dimension.width != this.oldWidth || dimension.height != this.oldHeight) {
            this.calculateSize(container);
        }
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            try {
                Object object;
                ListIterator listIterator = this.list.listIterator(0);
                Entry entry = null;
                while (listIterator.hasNext()) {
                    entry = (Entry)listIterator.next();
                    if (entry.component == componentArray[i]) break;
                    entry = null;
                }
                if (entry == null) {
                    componentArray[i].setBounds(0, 0, 0, 0);
                    continue;
                }
                int n = 0;
                int n2 = 0;
                if (entry.alignment[0] != 2 || entry.alignment[1] != 2) {
                    object = componentArray[i].getPreferredSize();
                    n = ((Dimension)object).width;
                    n2 = ((Dimension)object).height;
                }
                object = this.calculateSizeAndOffset(entry, n, true);
                Object object2 = object[0];
                Object object3 = object[1];
                object = this.calculateSizeAndOffset(entry, n2, false);
                Object object4 = object[0];
                Object object5 = object[1];
                ComponentOrientation componentOrientation = this.getComponentOrientation(container);
                if (!componentOrientation.isLeftToRight()) {
                    object2 = dimension.width - object2 - object3;
                }
                componentArray[i].setBounds((int)object2, (int)object4, (int)object3, (int)object5);
                continue;
            }
            catch (Exception exception) {
                componentArray[i].setBounds(0, 0, 0, 0);
            }
        }
    }

    protected ComponentOrientation getComponentOrientation(Container container) {
        ComponentOrientation componentOrientation = null;
        try {
            if (checkForComponentOrientationSupport) {
                methodGetComponentOrientation = Class.forName("java.awt.Container").getMethod("getComponentOrientation", new Class[0]);
                checkForComponentOrientationSupport = false;
            }
            if (methodGetComponentOrientation != null) {
                componentOrientation = (ComponentOrientation)methodGetComponentOrientation.invoke((Object)container, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return componentOrientation;
    }

    protected int[] calculateSizeAndOffset(Entry entry, int n, boolean bl) {
        int n2;
        int n3;
        int[] nArray = bl ? this.crOffset[0] : this.crOffset[1];
        int n4 = bl ? entry.alignment[0] : entry.alignment[1];
        int n5 = bl ? nArray[entry.cr2[0] + 1] - nArray[entry.cr1[0]] : nArray[entry.cr2[1] + 1] - nArray[entry.cr1[1]];
        int n6 = n4 == 2 || n5 < n ? n5 : n;
        if (bl && n4 == 4) {
            n4 = 0;
        }
        if (bl && n4 == 5) {
            n4 = 3;
        }
        switch (n4) {
            case 0: {
                n3 = nArray[bl ? entry.cr1[0] : entry.cr1[1]];
                break;
            }
            case 3: {
                n3 = nArray[(bl ? entry.cr2[0] : entry.cr2[1]) + 1] - n6;
                break;
            }
            case 1: {
                n3 = nArray[bl ? entry.cr1[0] : entry.cr1[1]] + (n5 - n6 >> 1);
                break;
            }
            case 2: {
                n3 = nArray[bl ? entry.cr1[0] : entry.cr1[1]];
                break;
            }
            default: {
                n3 = 0;
            }
        }
        if (bl) {
            n3 += this.hGap * entry.cr1[0];
            n2 = this.hGap * (entry.cr2[0] - entry.cr1[0]);
            switch (n4) {
                case 3: {
                    n3 += n2;
                    break;
                }
                case 1: {
                    n3 += n2 >> 1;
                    break;
                }
                case 2: {
                    n6 += n2;
                }
            }
        } else {
            n3 += this.vGap * entry.cr1[1];
            n2 = this.vGap * (entry.cr2[1] - entry.cr1[1]);
            switch (n4) {
                case 3: {
                    n3 += n2;
                    break;
                }
                case 1: {
                    n3 += n2 >> 1;
                    break;
                }
                case 2: {
                    n6 += n2;
                }
            }
        }
        int[] nArray2 = new int[]{n3, n6};
        return nArray2;
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.calculateLayoutSize(container, -2.0);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.calculateLayoutSize(container, -3.0);
    }

    protected Dimension calculateLayoutSize(Container container, double d) {
        int n;
        Entry[] entryArray = this.list.toArray(new Entry[this.list.size()]);
        int n2 = entryArray.length;
        Dimension[] dimensionArray = new Dimension[n2];
        for (n = 0; n < n2; ++n) {
            dimensionArray[n] = d == -2.0 ? entryArray[n].component.getPreferredSize() : entryArray[n].component.getMinimumSize();
        }
        n = this.calculateLayoutSize(container, 0, d, entryArray, dimensionArray);
        int n3 = this.calculateLayoutSize(container, 1, d, entryArray, dimensionArray);
        Insets insets = container.getInsets();
        return new Dimension(n += insets.left + insets.right, n3 += insets.top + insets.bottom);
    }

    protected int calculateLayoutSize(Container container, int n, double d, Entry[] entryArray, Dimension[] dimensionArray) {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = this.crSpec[n].length;
        double d2 = 1.0;
        int n6 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            if (this.crSpec[n][n3] > 0.0 && this.crSpec[n][n3] < 1.0) {
                d2 -= this.crSpec[n][n3];
                continue;
            }
            if (this.crSpec[n][n3] != -1.0) continue;
            ++n6;
        }
        if (n6 > 1) {
            d2 /= (double)n6;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        this.crSize[n] = new int[n5];
        this.assignAbsoluteSize(n, 0);
        this.assignPrefMinSize(n, 0, -3.0);
        this.assignPrefMinSize(n, 0, -2.0);
        int[] nArray = new int[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            if (this.crSpec[n][n3] != -2.0 && this.crSpec[n][n3] != -3.0) continue;
            nArray[n3] = this.crSize[n][n3];
        }
        int n7 = this.crSpec[0].length;
        int n8 = this.crSpec[1].length;
        int n9 = entryArray.length;
        for (n2 = 0; n2 < n9; ++n2) {
            Entry entry = entryArray[n2];
            if (entry.cr1[0] < 0 || entry.cr1[0] >= n7 || entry.cr2[0] >= n7 || entry.cr1[1] < 0 || entry.cr1[1] >= n8 || entry.cr2[1] >= n8) continue;
            Dimension dimension = dimensionArray[n2];
            int n10 = n == 0 ? dimension.width : dimension.height;
            for (n3 = entry.cr1[n]; n3 <= entry.cr2[n]; ++n3) {
                if (this.crSpec[n][n3] >= 1.0) {
                    n10 = (int)((double)n10 - this.crSpec[n][n3]);
                    continue;
                }
                if (this.crSpec[n][n3] != -2.0 && this.crSpec[n][n3] != -3.0) continue;
                n10 -= nArray[n3];
            }
            double d3 = 0.0;
            for (n3 = entry.cr1[n]; n3 <= entry.cr2[n]; ++n3) {
                if (this.crSpec[n][n3] > 0.0 && this.crSpec[n][n3] < 1.0) {
                    d3 += this.crSpec[n][n3];
                    continue;
                }
                if (this.crSpec[n][n3] != -1.0 || d2 == 0.0) continue;
                d3 += d2;
            }
            int n11 = d3 == 0.0 ? 0 : (int)((double)n10 / d3 + 0.5);
            if (n4 >= n11) continue;
            n4 = n11;
        }
        n2 = n4;
        for (n3 = 0; n3 < n5; ++n3) {
            if (this.crSpec[n][n3] >= 1.0) {
                n2 += (int)(this.crSpec[n][n3] + 0.5);
                continue;
            }
            if (this.crSpec[n][n3] != -2.0 && this.crSpec[n][n3] != -3.0) continue;
            n2 += nArray[n3];
        }
        if (n5 > 0) {
            n2 += (n == 0 ? this.hGap : this.vGap) * (n5 - 1);
        }
        return n2;
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof String) {
            object = new TableLayoutConstraints((String)object);
            this.list.add(new Entry(component, (TableLayoutConstraints)object));
            this.dirty = true;
        } else if (object instanceof TableLayoutConstraints) {
            this.list.add(new Entry(component, (TableLayoutConstraints)object));
            this.dirty = true;
        } else {
            if (object == null) {
                throw new IllegalArgumentException("No constraint for the component");
            }
            throw new IllegalArgumentException("Cannot accept a constraint of class " + object.getClass());
        }
    }

    public void removeLayoutComponent(Component component) {
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.component != component) continue;
            listIterator.remove();
        }
        this.dirty = true;
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
        this.dirty = true;
    }

    public static class Entry
    implements Cloneable {
        public Component component;
        public int[] cr1;
        public int[] cr2;
        public int[] alignment;

        public Entry(Component component, TableLayoutConstraints tableLayoutConstraints) {
            int[] nArray = new int[]{tableLayoutConstraints.col1, tableLayoutConstraints.row1};
            int[] nArray2 = new int[]{tableLayoutConstraints.col2, tableLayoutConstraints.row2};
            int[] nArray3 = new int[]{tableLayoutConstraints.hAlign, tableLayoutConstraints.vAlign};
            this.cr1 = nArray;
            this.cr2 = nArray2;
            this.alignment = nArray3;
            this.component = component;
        }

        public Object copy() throws CloneNotSupportedException {
            return this.clone();
        }

        public String toString() {
            TableLayoutConstraints tableLayoutConstraints = new TableLayoutConstraints(this.cr1[0], this.cr1[1], this.cr2[0], this.cr2[1], this.alignment[0], this.alignment[1]);
            return "(" + tableLayoutConstraints + ") " + this.component;
        }
    }
}

