/*
 * update_confirm.c
 * Code for updating the manual judgement of PCAPs to the database, "training_data" or "processing_data".
 */

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mysql.h>

#include "update_confirm.h"

static struct Pcap pcaps[MAXSIZE];


int main(int argc, char **argv)
{
	/*
	 * Get and parse command-line options
	 */
	int opt;
	char *processed_file;

	opt = 0;
	processed_file = NULL;
	while((opt = getopt(argc, argv, "f:")) != -1) {
		switch(opt) {
			case 'f':
				processed_file = optarg;
				break;
			default: /* '?' */
				fprintf(stderr, "Usage: %s [-f Processed_file]\n", argv[0]);
				exit(0);
		}
	}

	/* Instead of "if(optind >= argc)", because the getopt() does not set the initial value of optind to '0'. */
	if(optind == 1) {
		fprintf(stderr, "Expected argument after options\n");
		exit(0);
	}
	if(processed_file == NULL) {
		printf("Error: Processed file should be set.\n");
		exit(0);
	}



	pro_pcap_info(processed_file, pcaps);
	
	int i;
	char update_cmd[MAXLINE];
	
	MYSQL *conn;
    conn = mysql_init(NULL);

    if(conn == NULL) {
        printf("Error %u: %s\n", mysql_errno(conn), mysql_error(conn));
        exit(1);
    }
	if(mysql_real_connect(conn, DB_HOST, DB_USER, DB_PASSWORD, DB_DB, 0, NULL, 0 ) == NULL) {
        printf("Error %u: %s\n", mysql_errno(conn), mysql_error(conn));
        exit(1);
    }
	
	memset(update_cmd, 0, MAXLINE);
	for(i=0; i<MAXSIZE && pcaps[i].pcap_id[0]!=0; ++i) {
		sprintf(update_cmd, "UPDATE pcapInfo SET confirm='%d' WHERE pcap_id='%s'", pcaps[i].confirm, pcaps[i].pcap_id);
		printf("update_cmd[%d]=%s\n", i, update_cmd);
		mysql_query(conn, update_cmd);
	}
	
	mysql_close(conn);
	
	return 0;
}

void pro_pcap_info (char *file_path, struct Pcap *pcap_data)
{
    int i;
    char buf[MAXLINE], tmp[MAXLINE];
    FILE *fp;

    fp = fopen(file_path, "r");
    if(fp == NULL) exit(0);

    memset(pcap_data, 0, sizeof(struct Pcap)*MAXSIZE);

    for(i=0; i<MAXSIZE && fgets(buf, MAXLINE, fp)!=NULL; ++i) {
		char *p;

		p = strtok(buf, ".");
		if(p == NULL) { printf("This should not happen\n"); exit(0); }
		strncpy(pcap_data[i].pcap_id, p, sizeof(pcap_data[i].pcap_id));
		
		p = strtok(NULL, " (");
		if(p == NULL) { printf("This should not happen\n"); exit(0); }
		p = strtok(NULL, " ()");
        if(p == NULL) { printf("This should not happen\n"); exit(0); }
		strcpy(tmp, p);
		//printf("tmp_%d = %s\n", i, tmp);
		pcap_data[i].confirm = ((*p) == '1') ? 1 : 0;
	}	
	fclose(fp);
}

