/*
 * setup_alert_msg.c
 * Code for constructing the statistics of alert messages (for Alert Message level).
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mysql.h>

#include "setup_alert_msg.h"

static struct Alert alerts[MAXSIZE];


int main(int argc, char **argv)
{
	int i, j;
	
	MYSQL *conn_training;
	conn_training = mysql_init(NULL);

	if(conn_training == NULL) {
		printf("Error %u: %s\n", mysql_errno(conn_training), mysql_error(conn_training));
		exit(1);
	}

	/* Connect to database "training_data" */
	if(mysql_real_connect(conn_training, DB_HOST, DB_USER, DB_PASSWORD, DB_DB, 0, NULL, 0 ) == NULL) {
        printf("Error %u: %s\n", mysql_errno(conn_training), mysql_error(conn_training));
        exit(1);
	}

	/* Select from table "pcapInfo" and store into structure alerts */
	{
		MYSQL_RES *result;
		MYSQL_ROW row;
		int num_fields;

		memset(alerts, 0, sizeof(struct Alert)*MAXSIZE);
		i=0;
		mysql_query(conn_training, "SELECT msg, dev_name, confirm FROM pcapInfo");
		result = mysql_store_result(conn_training);
		num_fields = mysql_num_fields(result);
		while((row = mysql_fetch_row(result)) != NULL) {
			for(j=0; j<num_fields; ++j)
				printf("%s | " , row[j]);
			printf("\n");

			strncpy(alerts[i].msg, row[0], sizeof(alerts[i].msg)-1);
			strncpy(alerts[i].dev_name, row[1], sizeof(alerts[i].dev_name)-1);
			alerts[i].confirm = atol(row[2]);
			i++;
		}
		printf("===============================================================\n");
		mysql_free_result(result);
		
		printf("-----------After selecting from table 'pcapInfo'---------------\n");
		for(i=0; i<MAXSIZE && alerts[i].msg[0]!=0; ++i) {
			printf("alerts[%d].msg= %s\n", i, alerts[i].msg);
			printf("alerts[%d].dev_name= %s\n", i, alerts[i].dev_name);
			printf("alerts[%d].confirm= %d\n", i, alerts[i].confirm);
		}
		printf("---------------------------------------------------------------\n");
	}

	/* Do the stratistics of TP, FP, and Total. Then, store into structure alerts. Finally, insert into table "statistics_msg" */
	{
		char used[MAXSIZE];
		char insert_cmd[MAXLINE];

		for(i=0; i<MAXSIZE && alerts[i].msg[0]!=0; ++i) {
			alerts[i].total = 1;
			if(alerts[i].confirm == 1) { 
				alerts[i].tp = 1;
			}
			else if(alerts[i].confirm == 0) {
				alerts[i].fp = 1;
			}
		}

		memset(used, 0, MAXSIZE);
		for(i=0; i<MAXSIZE && alerts[i].msg[0]!=0; ++i) {
			if(used[i] == 1) continue;
			for(j=i+1; j<MAXSIZE && alerts[i].msg[0]!=0; ++j) {
				if(used[j] == 1) continue;
				if(strcmp(alerts[i].msg, alerts[j].msg) == 0) {
					used[j]=1;
					if(alerts[j].confirm == 1) {
						alerts[i].tp++;
						alerts[i].total++;
					}
					else if(alerts[j].confirm == 0) {
						alerts[i].fp++;
						alerts[i].total++;
					}
				}
			}
		}
		printf("--------After doing the statistics of tp, fp, and total--------\n");
		for(i=0; i<MAXSIZE && alerts[i].msg[0]!=0; ++i) {
			if(used[i] == 1) continue;
		    printf("alerts[%d].msg= %s\n", i, alerts[i].msg);
		    printf("alerts[%d].dev_name= %s\n", i, alerts[i].dev_name);
		    printf("alerts[%d].confirm= %d\n", i, alerts[i].confirm);
			printf("alerts[%d].tp= %d\n", i, alerts[i].tp);
			printf("alerts[%d].fp= %d\n", i, alerts[i].fp);
			printf("alerts[%d].total= %d\n", i, alerts[i].total);
	    }
		printf("---------------------------------------------------------------\n");

		memset(insert_cmd, 0, MAXLINE);
		for(i=0; i<MAXSIZE && alerts[i].msg[0]!=0; ++i) {
			if(used[i] == 1) continue;
			sprintf(insert_cmd, "INSERT INTO statistics_msg(msg, dev_name, tp, fp, total) VALUES('%s', '%s', '%d', '%d', '%d')", alerts[i].msg, alerts[i].dev_name, alerts[i].tp, alerts[i].fp, alerts[i].total);
			printf("insert_cmd=%s\n", insert_cmd);
			mysql_query(conn_training, insert_cmd);
		}
	}

	mysql_close(conn_training);

	return 0;
}

