/* 
 * cwv.h
 *
 * vendor 0: Fortinet FortiGate-110c
 * vendor 1: ZyXEL ZyWALL USG 1000
 * vendor 2: TippingPoint 5000E
 * vendor 3: Trend Micro TDA2
 * vendor 4: D-Link DFL-1600
 * vendor 5: BroadWeb NetKeeper7K
 * vendor 6: McAfee M-1250
 */

#define MAXSIZE 65536
#define MAXLINE 4096
#define NUMBER_OF_DEVICES 7

/* Input files */
//#define TRAINING_DATA_FILE "./data/training/HTTP_training_sample.txt"
//#define PROCESSING_DATA_FILE "./data/processing/HTTP_processing_sample.txt"

/* Variables for MySQL */
//#define DB_HOST "127.0.0.1" /* 0; localhost */
//#define DB_USER "root"
//#define DB_PASSWORD "9856514"
//#define DB_DB "HTTP_sample" /* Protocols, e.g., HTTP, FTP, NetBIOS, TELNET */

/* Parameters used in CWV */
#define DETECTION_THRESHOLD 0.5
#define ABNORMALITY_THRESHOLD 0.9
#define ALPHA 0.5
#define BETA 0.5

struct Trace {
	int num_pcaps;
	int num_mali;
};

struct Alert {
#define ID_LENGTH 32
	char pcap_id[ID_LENGTH];
	char alert[NUMBER_OF_DEVICES];
#define MAX_MSG_LENGTH 256
	char msg[NUMBER_OF_DEVICES][MAX_MSG_LENGTH];
#define MAX_DEV_NAME_LENGTH 64
	char dev_name[NUMBER_OF_DEVICES][MAX_DEV_NAME_LENGTH];
	char confirm;
	char v_result;
};

struct Vendor {
	float TP;
	float FP;
	float TN;
	float FN;
	float weight[2];
	int authority;
	int excluded;
};

void pre_pcap_id_from_file (char *file_path, struct Alert *alert_data);
void pre_alert_from_db (struct Alert *alert_data, char *db_host, char *db_user, char *db_password, char *db_db);
int pre_alert_info (char *file_path, struct Alert *alert_data);
int pre_trace_info (struct Alert *alert_data, struct Trace *trace_data);
void pre_vendor_info ();
void selection_sort (float *elements, int num_elements);
int authority_selecting ();
void direct_decision();
int voter_excluding ();
int weighted_voting (int num_voters, char *db_host, char *db_user, char *db_password, char *db_db);
int majority_voting ();
void help_msg ();

