#include <stdio.h>
#include <netinet/in.h>
#include <linux/un.h>
#include <string.h>
#include <sys/types.h>
#include <arpa/inet.h>
#include <err.h>
#include <unistd.h>

int main(int argc, char ** argv)
{
	if(argc != 3) errx(1, "Usage: %s [usock-path] [string]", argv[0]);

	{
		struct sockaddr_un addr;
		int fd;

		if((fd = socket(AF_UNIX, SOCK_DGRAM, 0)) == -1) err(1, "socket");

		memset(&addr, 0, sizeof(struct sockaddr_un));
		addr.sun_family = AF_UNIX;
		strcpy(addr.sun_path, argv[1]);

		if(sendto(fd, argv[2], strlen(argv[2]), 0, (struct sockaddr *) &addr, sizeof(struct sockaddr_un)) == -1) err(1, "sendto");

		close(fd);
	}

	return 0;
}

