# $1 for machine name
# $2 for sending code
function send()
{
	local machine="${1}"
    local arg="${2}"

    # cannot quote
    local code=`ascii2scan ${arg}`
    ${VB} controlvm "${machine}" keyboardputscancode ${code} > /dev/null
}

# $1 for machine name
function power_off()
{
	local machine="${1}"

    send "${machine}" "-w"; sleep 3;
    send "${machine}" "-s u"; sleep 1;
    send "${machine}" "-s u"; sleep 1;
    send "${machine}" "-s u"; sleep 1;
}

# $1 for machine name
function soft_power_off()
{
	local machine="${1}"

    power_off "${machine}";

    local flag=1
    local rflag=0
    while [ 1 ];
    do
        local vms=`${VB} list runningvms | grep "\"${machine}\""`
        if [ -z "${vms}" ]; then
            break
        fi

        echo "======> wait ${machine} shutdown..."

        if [ "${rflag}" -gt 2 ]; then
			echo "======> force power off..."
            ${VB} controlvm "${machine}" poweroff
            sleep 3
            continue
        fi

        if [ "${flag}" -ge 3 ]; then
            send "${machine}" "-s e"; sleep 1;
            power_off "${machine}";
            echo "======> resend power off..."
            flag=1
            rflag=$((${rflag}+1))
        else
            flag=$((${flag}+1))
        fi

        sleep 3
    done
}

