#!/bin/sh

function usage()
{
	echo "Usage: sh depend.sh [ -f [ file ] | -d [dir] ]"
	exit
}

while getopts f:d: opt
do
    case "${opt}" in
        f) file="${OPTARG}" break ;;
        d) dir="${OPTARG}" break ;;
        ?) usage; ;;
    esac
done

if [ ! -z "${file}" ]; then
    lists="${file}"
elif [ ! -z "${dir}" ]; then
    lists=`ls -1 "${dir}"`
else
    usage;
fi

VBoxManage -q controlvm LabXP keyboardputscancode `./ascii2scan -w`; sleep 1
VBoxManage -q controlvm LabXP keyboardputscancode `./ascii2scan -s r`; sleep 1
VBoxManage -q controlvm LabXP keyboardputscancode `./ascii2scan -n cmd`; sleep 1
VBoxManage -q controlvm LabXP keyboardputscancode `./ascii2scan -s cd -S -n depend`; sleep 1
for i in $lists
do
    if [ ! -z "${dir}" ]; then
		malware="${dir}"/"${i}"
	else
		malware="${i}"
	fi

	cp ${malware} .
	name=`basename ${malware}`
	cp ${name} /home/ftp

	VBoxManage -q controlvm LabXP keyboardputscancode `./ascii2scan -s ftp -S -s-n -S -n 192.168.56.1`;
	VBoxManage -q controlvm LabXP keyboardputscancode `./ascii2scan -s user -S -n bbc`;
	VBoxManage -q controlvm LabXP keyboardputscancode `./ascii2scan -n pp654321`;
	VBoxManage -q controlvm LabXP keyboardputscancode `./ascii2scan -n binary`;
	VBoxManage -q controlvm LabXP keyboardputscancode `./ascii2scan -s get -S -n ${name}`; sleep 1
	VBoxManage -q controlvm LabXP keyboardputscancode `./ascii2scan -n quit`;

	VBoxManage -q controlvm LabXP keyboardputscancode `./ascii2scan -s depends -S -s /c -S`;
	VBoxManage -q controlvm LabXP keyboardputscancode `./ascii2scan -s /oc:${name}.txt -S`;
	VBoxManage -q controlvm LabXP keyboardputscancode `./ascii2scan -n ${name}`; sleep 1;

	VBoxManage -q controlvm LabXP keyboardputscancode `./ascii2scan -s del -S -n ${name}`;

	rm -f ${name}
	rm -f /home/ftp/${name}
done
VBoxManage -q controlvm LabXP keyboardputscancode `./ascii2scan -n exit`;

