#include <stdio.h>
#include <unistd.h>

static char ascii_without_shift [][2]= {
	"1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "0\0", "-\0", "=\0",
	"q\0", "w\0", "e\0", "r\0", "t\0", "y\0", "u\0", "i\0", "o\0", "p\0", "[\0", "]\0",
	"a\0", "s\0", "d\0", "f\0", "g\0", "h\0", "j\0", "k\0", "l\0", ";\0", "'\0", "`\0", "\\\0",
	"z\0", "x\0", "c\0", "v\0", "b\0", "n\0", "m\0", ",\0", ".\0", "/\0"
};

static char ascii_with_shift [][2] = {
	"!\0", "@\0", "#\0", "$\0", "%\0", "^\0", "&\0", "*\0", "(\0", ")\0", "_\0", "+\0",
	"Q\0", "W\0", "E\0", "R\0", "T\0", "Y\0", "U\0", "I\0", "O\0", "P\0", "{\0", "}\0",
	"A\0", "S\0", "D\0", "F\0", "G\0", "H\0", "J\0", "K\0", "L\0", ":\0", "\"\0", "~\0", "|\0",
	"Z\0", "X\0", "C\0", "V\0", "B\0", "N\0", "M\0", "<\0", ">\0", "?\0"
};

static char ascii_mark_scancode [][3] = {
	"02\0", "03\0", "04\0", "05\0", "06\0", "07\0", "08\0", "09\0", "0a\0", "0b\0", "0c\0", "0d\0",
	"10\0", "11\0", "12\0", "13\0", "14\0", "15\0", "16\0", "17\0", "18\0", "19\0", "1a\0", "1b\0",
	"1e\0", "1f\0", "20\0", "21\0", "22\0", "23\0", "24\0", "25\0", "26\0", "27\0", "28\0", "29\0", "2b\0",
	"2c\0", "2d\0", "2e\0", "2f\0", "30\0", "31\0", "32\0", "33\0", "34\0", "35\0"
};

static char ascii_break_scancode [][3] = {
	"82\0", "83\0", "84\0", "85\0", "86\0", "87\0", "88\0", "89\0", "8a\0", "8b\0", "8c\0", "8d\0",
	"90\0", "91\0", "92\0", "93\0", "94\0", "95\0", "96\0", "97\0", "98\0", "99\0", "9a\0", "9b\0",
	"9e\0", "9f\0", "a0\0", "a1\0", "a2\0", "a3\0", "a4\0", "a5\0", "a6\0", "a7\0", "a8\0", "a9\0", "ab\0",
	"ac\0", "ad\0", "ae\0", "af\0", "b0\0", "b1\0", "b2\0", "b3\0", "b4\0", "b5\0"
};

static char * shift_mark_scancode = "2a\0";
static char * shift_break_scancode = "aa\0";
static char * enter_mark_scancode = "1c\0";
static char * enter_break_scancode = "9c\0";
static char * space_mark_scancode = "39\0";
static char * space_break_scancode = "b9\0";

void help(char * cmd)
{
	printf("Usage: %s [options] [source-string]\n", cmd);
	printf("Options --\t-w\tWindows key\n");
	printf("        --\t-s\tSingle translate\n");
	printf("        --\t-S\tSpace\n");
	printf("        --\t-n\tEnd with newline\n");
}

void translate(char * str)
{
	int i;

		for(i=0; str[i]!=0; ++i) {
			if(str[i] == ' ') {
				printf("%s %s ", space_mark_scancode, space_break_scancode);
			} else {
				int k;

				for(k=0; ascii_without_shift[k]!=0; ++k) {
					if(str[i] == ascii_without_shift[k][0]) {
						printf("%s %s ", ascii_mark_scancode[k], ascii_break_scancode[k]);
						goto DONE;
					}

					if(str[i] == ascii_with_shift[k][0]) {
						printf("%s %s %s %s ", shift_mark_scancode, ascii_mark_scancode[k], ascii_break_scancode[k], shift_break_scancode);
						goto DONE;
					}
				}
			}
DONE:
			;
		}
}

int main(int argc, char ** argv)
{
	char ch;

	if(argc < 2) {
		help(argv[0]);
		return -1;
	}

	while((ch = getopt(argc, argv, "ws:Sn:")) != -1) {
		switch(ch) {
			case 'w':
				/* ctrl+esc */
				printf("%s %s %s %s ", "1d\0", "01\0", "81\0", "9d\0");
				break;
			case 's':
				translate(optarg);
				break;
			case 'S':
				printf("%s %s ", space_mark_scancode, space_break_scancode);
				break;
			case 'n':
				translate(optarg);
				printf("%s %s ", enter_mark_scancode, enter_break_scancode);
				break;
			default:
				break;
		}
	}
	
	printf("\n");

	return 0;
}
