# start point of tbshr's thesis
#!/bin/sh

function usage()
{
	echo "Usage: sh start.sh [ [-f file] | [-d dir] ] [-b blacklist]"
	exit 1
}

function sigint_handler()
{
	echo "SIGINT"
	signal=1
}

function wait_signal()
{
	while [ 1 ];
	do
		if [ -n "${signal}" ]; then
			break
		fi
		sleep 3
	done
}

function sleep_600()
{
	local k=600
	while [ "$k" -gt 0 ];
	do
		sleep 1
		k=$(($k-1))
		echo "${k}"
	done
}

function check_port()
{
	while [ 1 ];
	do
		if [ "${emulator_port}" -gt 62040 ]; then
			emulator_port=62020
		fi

		port_check=`netstat -nat | grep -i -e "LISTEN" -e "ESTABLISHED" -e "TIME_WAIT" | grep "${emulator_port}"`
		if [ -z "${port_check}" ]; then
			break;
		fi

		echo "======> change port..."
		emulator_port=$((${emulator_port}+1))
	done
}

. tools/libtbshr.sh

function doit()
{
	cp "${malware}" "${prefix}"

#	rm -f emulator_controller.conf
#	echo "Emulator_XP_SP0" >> emulator_controller.conf
#	echo "Emulator_XP_SP1" >> emulator_controller.conf
#	echo "Emulator_XP_SP2" >> emulator_controller.conf
#	echo "Emulator_Ubuntu" >> emulator_controller.conf

#	check_port;
#	emulator_controller -c emulator_controller.conf -p ${emulator_port} &
#	emulator_controller_pid=${!}

	optional=""
	if [ -n "${blacklist}" ]; then
		optional="${optional} -b ${blacklist}"
	fi

	if [ -n "${open}" ]; then
		ssh root@192.168.56.110 "cd /home/tbshr/tbshr_thesis/; \
			export PATH=\"${PATH}\"; \
			DispatcherRunner.sh ${optional} -p ${prefix} -o 0 -z eth0 -Z 140.113.88.178 -m 08:00:27:04:38:DE -M 00:19:06:e8:0e:4a -v ${verdict} \
			-i eth1 -I 140.113.88.187 -d eth2 -D 140.113.88.100/08:00:27:D4:F7:27/n -O";
#-i eth1 -I 140.113.88.187 -d eth2 -D 140.113.188.88/08:00:27:3F:1A:BA/m -O";
	else
		ssh root@192.168.56.110 "cd /home/tbshr/tbshr_thesis/; \
			export PATH=\"${PATH}\"; \
			DispatcherRunner.sh ${optional} -p ${prefix} -o 0 -z eth0 -Z 140.113.88.178 -m 08:00:27:04:38:DE -M 00:19:06:e8:0e:4a -v ${verdict} \
			-i eth1 -I 140.113.88.187 -d eth2 -D 140.113.88.100/08:00:27:D4:F7:27/n";
#			-i eth1 -I 140.113.88.187 -d eth2 -D 140.113.188.88/08:00:27:3F:1A:BA/m";
	fi

	screen -S tcpGG -d -m sudo tcpdump -n -i eth0 host 140.113.88.187 -w to_Internet_${prefix}.pcap

	BotRunner.sh "`pwd`/${prefix}" "Bot_XP_SP0" 0

	sleep_600;
#	wait_signal;

#	while read line
#	do
#		emulator_controller.sh 1 "${line}"
#	done<emulator_controller.conf

	BotRunner.sh "`pwd`/${prefix}" "Bot_XP_SP0" 1

	ssh root@192.168.56.110 "cd /home/tbshr/tbshr_thesis/; \
		export PATH=\"${PATH}\"; \
		DispatcherRunner.sh -p ${prefix} -o 1 -z eth0 -Z 140.113.88.178 -m 08:00:27:04:38:DE -M 00:19:06:e8:0e:4a -v ${verdict} \
		-i eth1 -I 140.113.88.187 -d eth2 -D 140.113.188.88/08:00:27:3F:1A:BA/m"
	ssh root@192.168.56.110 "cd /home/tbshr/tbshr_thesis/; \
		export PATH=\"${PATH}\"; \
		DispatcherRunner.sh -p ${prefix} -o 2 -z eth0 -Z 140.113.88.178 -m 08:00:27:04:38:DE -M 00:19:06:e8:0e:4a -v ${verdict} \
		-i eth1 -I 140.113.88.187 -d eth2 -D 140.113.188.88/08:00:27:3F:1A:BA/m"

#	kill -15 "${emulator_controller_pid}"
#	rm -f emulator_controller.conf

	rm -f "${prefix}"
#	emulator_port=$((${emulator_port}+1))

	sudo kill -15 `pidof tcpdump`

	VB="VBoxManage -q"
	soft_power_off Emulator_XP_SP0; sleep 3
	${VB} snapshot Emulator_XP_SP0 restore Clean1
	sleep 5
	${VB} startvm Emulator_XP_SP0
}


export PATH="bin:${PATH}"

while getopts f:d:b:O opt
do
	case "${opt}" in
		f) file="${OPTARG}" ;;
		d) dir="${OPTARG}" ;;
		b) blacklist="${OPTARG}" ;;
		O) open=1 ;;
		?) usage; ;;
	esac
done

if [ ! -z "${file}" ]; then
	lists="${file}"
elif [ ! -z "${dir}" ]; then
	lists=`ls -1 "${dir}"`
else
	usage;
fi

trap sigint_handler 2

#make emulator_controller_install; make scripts_install
make scripts_install
ssh root@192.168.56.110 "cd /home/tbshr/tbshr_thesis/; make install;"
#emulator_port=62020
for i in ${lists}
do
	if [ ! -z "${dir}" ]; then
		malware="${dir}"/"${i}"
	else
		malware="${i}"
	fi


	echo "======> handling ${malware} ..."

	file_result=`file ${malware} | grep -i "windows" | grep -i "executable"`
	exe_result=`basename ${malware} | grep -e "\.exe$"`
	if [ -z "${file_result}" ]; then
		echo "======> can not handle file type \"`file ${malware}`\""
	elif [ -z "${exe_result}" ]; then
		echo "======> can not handle non-exe file name \"${malware}\""
	else
		if [ -z "${open}" ]; then
			prefix="dispatcher_`basename ${malware}`"
			verdict="ACCEPT"
			doit;

#			prefix="closed_`basename ${malware}`"
#			verdict="DROP"
#			doit;
		else
			prefix="open_`basename ${malware}`"
			verdict="ACCEPT"
			doit
		fi
	fi
done
make clean
ssh root@192.168.56.110 "cd /home/tbshr/tbshr_thesis/; make clean;"

