# Run on dispatcher
#!/bin/sh

function usage()
{
	echo "Usage: sh DispatcherRunner.sh [-p prefix] [-o opcode] [-z internet_if] [-Z virtualbox_host_ip] \
		[-m bot_mac] [-M gateway_mac] [-v verdict] \
		[-i bot_if] [-I bot_ip] [-e emulator_if] [-E emulator_controller_ip:port] [-d decoy_if] [-D decoys] [-b blacklist]"
	exit 1
}

function init()
{
	brctl addbr br0
	brctl addif br0 "${internet_if}"
	brctl addif br0 "${bot_if}"
	ifconfig br0 up
	ifconfig "${internet_if}" up
	ifconfig "${bot_if}" up
	ifconfig "${decoy_if}" up

	iptables -F
	iptables -X
	iptables -Z
	iptables -P FORWARD DROP
	iptables -A FORWARD -s "${virtualbox_host_ip}" -j ACCEPT
	iptables -A FORWARD -d "${virtualbox_host_ip}" -j ACCEPT
iptables -A FORWARD -i br0 -p udp -j ACCEPT
	iptables -A FORWARD -i br0 -s "${bot_ip}" -j QUEUE
	iptables -A FORWARD -i br0 -d "${bot_ip}" -j ACCEPT

	mkdir -p run

	if [ -n "${open}" ]; then
		screen -S dispatcher -d -m dispatcher -m "${bot_mac}" -M "${gateway_mac}" -v "${verdict}" -l run/"${prefix}"_dispatcher.log
	elif [ -n "${blacklist}" ]; then
		screen -S dispatcher -d -m dispatcher -m "${bot_mac}" -M "${gateway_mac}" -v "${verdict}" -i br0 -I "${bot_ip}" -d "${decoy_if}" -D "${decoys}" \
			-b "${blacklist}" -j run/dispatcher.usock -l run/"${prefix}"_dispatcher.log
	else
#screen -S dispatcher -d -m valgrind --leak-check=full --log-file=valgrind.txt dispatcher -m "${bot_mac}" -M "${gateway_mac}" -v "${verdict}" -i br0 -I "${bot_ip}" -d "${decoy_if}" -D "${decoys}" \
		screen -S dispatcher -d -m dispatcher -m "${bot_mac}" -M "${gateway_mac}" -v "${verdict}" -i br0 -I "${bot_ip}" -d "${decoy_if}" -D "${decoys}" \
			-j run/dispatcher.usock -l run/"${prefix}"_dispatcher.log
	fi

	if [ -z "${open}" ]; then
		mkdir run/"${prefix}_snort_log"
#screen -S snort -d -m /usr/local/bin/snort -q -c /etc/snort/snort.conf -A fast -K ascii -l run/"${prefix}"_snort_log -i br0 -j run/dispatcher.usock host "${bot_ip}" and not host "${virtualbox_host_ip}" > /dev/null
		screen -S snort -d -m /usr/local/bin/snort -q -c /etc/snort/snort.conf -l run/"${prefix}"_snort_log -i br0 -j run/dispatcher.usock host "${bot_ip}" and not host "${virtualbox_host_ip}" > /dev/null
	fi

	screen -S tcpdump1 -d -m tcpdump -n -i "${bot_if}" -s 0 -w run/"${prefix}"_from_bot.pcap host "${bot_ip}" > /dev/null

	screen -S tcpdump3 -d -m tcpdump -n -i "${internet_if}" -s 0 -w run/"${prefix}"_to_internet.pcap host "${bot_ip}" > /dev/null

	screen -S tcpdump2 -d -m tcpdump -n -i "${decoy_if}" -s 0 -w run/"${prefix}"_emulation_network.pcap host "${bot_ip}" > /dev/null
}

function deinit()
{
	iptables -F
	iptables -X
	iptables -Z

	ifconfig "${decoy_if}" down
	ifconfig "${bot_if}" down
	ifconfig "${internet_if}" down
	ifconfig br0 down
	brctl delbr br0
}

function kill_processes()
{
	kill -15 `pidof dispatcher`
	kill -15 `pidof snort`
	kill -15 `pidof tcpdump`
	rm -f run/dispatcher.usock
}



user=`whoami`
if [ "${user}" != "root" ]; then
	echo "Need root permission!"
	exit 1
fi

while getopts p:o:z:Z:m:M:v:i:I:e:E:d:D:b:O opt
do
	case "${opt}" in
		p) prefix="${OPTARG}" ;;
		o) opcode="${OPTARG}" ;;
		z) internet_if="${OPTARG}" ;;
		Z) virtualbox_host_ip="${OPTARG}" ;;

		m) bot_mac="${OPTARG}" ;;
		M) gateway_mac="${OPTARG}" ;;
		v) verdict="${OPTARG}" ;;

		i) bot_if="${OPTARG}" ;;
		I) bot_ip="${OPTARG}" ;;
		e) emulator_if="${OPTARG}" ;;
		E) emulator_controller="${OPTARG}" ;;
		d) decoy_if="${OPTARG}" ;;
		D) decoys="${OPTARG}" ;;
		b) blacklist="${OPTARG}" ;;
		O) open=1 ;;
		?) usage; ;;
	esac
done

if [ -z "${prefix}" -o -z "${opcode}" -o -z "${internet_if}" -o -z "${virtualbox_host_ip}" -o \
	   -z "${bot_mac}" -o -z "${gateway_mac}" -o -z "${verdict}" -o \
	   -z "${bot_if}" -o -z "${bot_ip}" -o -z "${decoy_if}" -o -z "${decoys}" ]; then
	usage;
fi

case "${opcode}" in
	0) init; ;;
	1) kill_processes; ;;
	2) deinit; ;;
	?) usage; ;;
esac

