#include <stdio.h>
#include <stdlib.h>
#include <err.h>
#include <signal.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <string.h>
#include <sys/wait.h>

#define PORT 25
static int total_mail = 0;

void sigchld(int x)
{
	wait(NULL);
}

void sigint(int x)
{
	exit(0);
}

void statistic()
{
	printf("total_mail=%d\n", total_mail);
}

void writen(int fd, char * msg, int msg_len)
{
	int n;
	char * p;

	p = msg;
	while(msg_len > 0) {
		if((n = write(fd, p, msg_len)) == -1) err(1, "write");
		msg_len -= n;
		p += n;
	}
}

void chomp(char * msg)
{
	int len;

	len = strlen(msg);

	if(len-2 >= 0) {
		if(msg[len-2] == '\r') msg[len-2] = 0;
	}

	if(len-1 >= 0) {
		if(msg[len-1] == '\n') msg[len-1] = 0;
	}
}

void smtp(int fd)
{
	int recv;
	char buf[BUFSIZ];

#define INIT_RESPONSE "220 smtp.emu.org ESMTP Postfix\r\n"
	writen(fd, INIT_RESPONSE, strlen(INIT_RESPONSE));
	while(1) {
		char msg[BUFSIZ];

		memset(buf, 0, BUFSIZ);
		if((recv = read(fd, buf, BUFSIZ-1)) == -1) err(1, "read");
		else if(recv == 0) exit(1);

		chomp(buf);

		if(strncasecmp(buf, "ehlo", 4) == 0) {
			sprintf(msg, "250-smtp.emu.org\r\n250-8BITMIME\r\n250-SIZE 41943040\r\n250 PIPELINING\r\n");
			writen(fd, msg, strlen(msg));
		} else if(strncasecmp(buf, "mail", 4) == 0) {
			char * p;

			if((p = index(buf, ':')) == NULL) { sprintf(msg, "250 sender %s ok\r\n", buf); }
			else { sprintf(msg, "250 sender %s ok\r\n", p+1); }
			writen(fd, msg, strlen(msg));
		} else if(strncasecmp(buf, "rcpt", 4) == 0) {
			char * p;

			if((p = index(buf, ':')) == NULL) { sprintf(msg, "250 recipient %s ok\r\n", buf); }
			else { sprintf(msg, "250 recipient %s ok\r\n", p+1); }
			writen(fd, msg, strlen(msg));
		} else if(strncasecmp(buf, "data", 4) == 0) {
			sprintf(msg, "354 go ahead\r\n");
			writen(fd, msg, strlen(msg));

			while(1) {
				memset(buf, 0, BUFSIZ);
				if((recv = read(fd, buf, BUFSIZ-1)) == -1) err(1, "read");
				else if(recv == 0) exit(1);

				if(strcmp(buf, "\r\n") == 0) break;
			}
			while(1) {
				memset(buf, 0, BUFSIZ);
				if((recv = read(fd, buf, BUFSIZ-1)) == -1) err(1, "read");
				else if(recv == 0) exit(1);

				if(strcmp(buf, ".\r\n") == 0) break;
			}

			sprintf(msg, "250 ok dirdel 4/1\r\n");
			writen(fd, msg, strlen(msg));

			total_mail++;
		} else {
			sprintf(msg, "250 GG\r\n");
			writen(fd, msg, strlen(msg));
		}
	}
}

int main()
{
	int sfd;
	struct sockaddr_in addr;

	if((sfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) err(1, "socket");
	memset(&addr, 0, sizeof(struct sockaddr_in));
	addr.sin_family = AF_INET;
	addr.sin_port = htons(PORT);
	if(bind(sfd, (struct sockaddr *) &addr, sizeof(struct sockaddr)) == -1) err(1, "bind");
	if(listen(sfd, 5) == -1) err(1, "listen");

	signal(SIGCHLD, sigchld);
	signal(SIGINT, sigint);
	atexit(statistic);

	while(1) {
		int cfd;
		struct sockaddr_in caddr;
		socklen_t caddr_len;
		pid_t pid;

		memset(&caddr, 0, sizeof(struct sockaddr_in));
		caddr_len = sizeof(struct sockaddr_in);
		if((cfd = accept(sfd, (struct sockaddr *) &caddr, &caddr_len)) == -1) err(1, "accept");

		if((pid = fork()) == -1) { err(1, "fork"); }
		else if(pid == 0) { close(sfd); smtp(cfd); exit(0); }
		else { close(cfd); }
	}
}
