#!/bin/sh

function usage()
{
	echo "Usage: adaptive_ip_daemon.sh [op] [machine]"
	exit 1
}

. libtbshr.sh

# $1 for ip address
function get_emulator()
{
    # temp implement
    local ip="`echo "${1}" | cut -d'.' -f1-3`.222"

    # open executer
    send "${machine}" "-w"; sleep 3;
    send "${machine}" "-s r"; sleep 3;

    # type cmd
    send "${machine}" "-n cmd"; sleep 3;

    # setting ip address, netmask and gateway
	send "${machine}" "-s cd -S -s \"My -S -n Documents\""; sleep 2;
	send "${machine}" "-s adpip -S -s ${1} -S"; sleep 2;
	send "${machine}" "-n ${ip}"; sleep 2;

	sleep 10

    # very depend on software interface
    local mac=`${VB} showvminfo "${machine}" | grep "MAC" | awk -F',' '{print $1}' | awk -F' ' '{print $4}'`
    echo "${mac}"
}

function put_emulator()
{
    soft_power_off "${machine}";

    ${VB} snapshot "${machine}" restore Clean1 > /dev/null
    ${VB} startvm "${machine}" > /dev/null
}

# for fast multiphase
function get_emulator2()
{
	local mac=`${VB} showvminfo "${machine}" | grep "MAC" | awk -F',' '{print $1}' | awk -F' ' '{print $4}'`
	echo "${mac}"
}

# $1 for ip address
function get_emulator3()
{
    # temp implement
    local ip="`echo "${1}" | cut -d'.' -f1-3`.222"

    ssh root@192.168.56.106 "ifconfig eth0 inet ${1} netmask 255.255.255.0; \
        route add default gw ${ip};";

    # very depend on software interface
    local mac=`${VB} showvminfo "${machine}" | grep "MAC" | grep "emulators" | awk -F',' '{print $1}' | awk -F' ' '{print $4}'`
    echo "${mac}"
}

function put_emulator3()
{
    ssh root@192.168.56.106 "ifconfig eth0 inet 0.0.0.0 down;";
	exit 1

    ssh root@192.168.56.106 "init 0;";

    while [ 1 ];
    do
        local vms=`${VB} list runningvms | grep "\"${machine}\""`
        if [ -z "${vms}" ]; then
            break
        fi
        echo "wait Emulator die..."
        sleep 3
    done

    ${VB} snapshot "${machine}" restore Clean1 > /dev/null
    ${VB} startvm "${machine}" > /dev/null
}

VB="VBoxManage -q"

# $1 for opcode, 0 for GET, 1 for PUT
# $2 for VirtualBox machine name
if [ -z "${1}" ] || [ -z "${2}" ]; then
	usage;
fi

opcode="${1}"
machine="${2}"
case "${opcode}" in
	0)
#		get_emulator2;
#		exit 1

		if [ -z "${3}" ]; then
			echo "GET lose parameter"
			exit 1
		fi
		get_emulator3 "${3}";
		;;
	1)
		put_emulator3;
		;;
	?) usage; ;;
esac

