#include <stdio.h>
#include <err.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#define DEFAULT_PORT 48080
#define DEFAULT_CONF "emulator_controller.conf"

#define MSG_OK "200 OK"
#define MSG_NO_RESOURCE "300 NO_RESOURCE"
#define MSG_ERROR "400 ERROR"

struct resource {
	char name[BUFSIZ];	/* VBox machine name */
	char bind_name[BUFSIZ];	/* ip address */
	char used;
	struct resource * next;
};

void writen(int fd, char * msg, int len)
{
	int ret;

	if((ret = write(fd, msg, len)) == -1) err(1, "write");
	else if(ret != len) warnx("write length not match");
}

int main(int argc, char ** argv)
{
	int sfd;
	struct sockaddr_in server;
	u_int16_t port;
	char conf[BUFSIZ];
	char buf[BUFSIZ];
	struct resource * resources;

	port = DEFAULT_PORT;
	strncpy(conf, DEFAULT_CONF, sizeof(conf));
	resources = NULL;

	{
		char ch;

		while((ch = getopt(argc, argv, "p:c:")) != -1) {
			switch(ch) {
				case 'p': port = strtol(optarg, NULL, 10); break;
				case 'c': strncpy(conf, optarg, sizeof(conf)); break;
			}
		}
	}

	{
		FILE * fp;

		if((fp = fopen(conf, "r")) == NULL) err(1, "fopen");

		while(fgets(buf, BUFSIZ, fp) != NULL) {
			struct resource * new_resource;
			
			if(buf[strlen(buf) - 1] == '\n') buf[strlen(buf) - 1] = 0;

			if((new_resource = (struct resource *) malloc(sizeof(struct resource))) == NULL) err(1, "malloc");
			memset(new_resource, 0, sizeof(struct resource));
			strncpy(new_resource->name, buf, sizeof(new_resource->name));

			if(resources == NULL) { resources = new_resource; }
			else {
				struct resource * tail;

				for(tail=resources; tail->next!=NULL; tail=tail->next) ;

				tail->next = new_resource;
			}
		}

		if(fclose(fp) == EOF) warn("fclose");
	}

	if((sfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) err(1, "socket");
	
	memset(&server, 0, sizeof(struct sockaddr));
	server.sin_family = AF_INET;
	server.sin_port = htons(port);

	if(bind(sfd, (struct sockaddr *) &server, sizeof(struct sockaddr_in)) == -1) err(1, "bind");
	if(listen(sfd, 2) == -1) err(1, "listen");
	if(inet_ntop(AF_INET, &server.sin_addr.s_addr, buf, BUFSIZ) == NULL) warn("inet_ntop");
	warnx("listen on %s:%d", buf, ntohs(server.sin_port));

	while(1) {
		int cfd, ret;
		struct sockaddr_in client;
		socklen_t client_len;

		memset(&client, 0, sizeof(struct sockaddr_in));
		client_len = sizeof(struct sockaddr_in);

		if((cfd = accept(sfd, (struct sockaddr *) &client, &client_len)) == -1) err(1, "accept");

		memset(buf, 0, BUFSIZ);
		if(inet_ntop(AF_INET, &client.sin_addr.s_addr, buf, BUFSIZ) == NULL) warn("inet_ntop");
		warnx("client [%s:%d]", buf, ntohs(client.sin_port));

		while(1) {
			if((ret = read(cfd, buf, BUFSIZ-1)) == -1) { err(1, "read"); }
			else if(ret == 0) { warnx("connection broken"); break; }
			buf[ret] = 0;

			if(strncmp(buf, "EXIT", ret < 4 ? ret : 4) == 0) { warnx("client exit"); break; }
			else if(strncmp(buf, "GET", ret < 3 ? ret : 3) == 0) {
				struct resource * res;
				char ip[BUFSIZ];

				/* GET [ip-address] */
				if(sscanf(buf, "GET %s", ip) != 1) {
					sprintf(buf, "%s\r\n", MSG_ERROR);
					writen(cfd, buf, strlen(buf));
				}

				for(res=resources; res!=NULL; res=res->next)
					if(!res->used)
						break;
				if(res == NULL) {
					sprintf(buf, "%s\r\n", MSG_NO_RESOURCE);
					writen(cfd, buf, strlen(buf));
				} else {
					FILE * fp;
					char mac[BUFSIZ];

					strcpy(res->bind_name, ip);
					res->used = 1;

					sprintf(buf, "emulator_controller.sh 0 %s %s", res->name, ip);
					if((fp = popen(buf, "r")) == NULL) err(1, "popen");
					fgets(buf, BUFSIZ, fp);
					if(buf[strlen(buf) - 1] == '\n') buf[strlen(buf) - 1] = 0;

					memset(mac, 0, BUFSIZ);
					mac[0] = buf[0];
					mac[1] = buf[1];
					mac[2] = ':';
					mac[3] = buf[2];
					mac[4] = buf[3];
					mac[5] = ':';
					mac[6] = buf[4];
					mac[7] = buf[5];
					mac[8] = ':';
					mac[9] = buf[6];
					mac[10] = buf[7];
					mac[11] = ':';
					mac[12] = buf[8];
					mac[13] = buf[9];
					mac[14] = ':';
					mac[15] = buf[10];
					mac[16] = buf[11];

					sprintf(buf, "%s %s\r\n", MSG_OK, mac);
					writen(cfd, buf, strlen(buf));

					warnx("get %s", ip);

					if(fclose(fp) == EOF) warn("fclose");
				}

			} else if(strncasecmp(buf, "PUT", ret < 3 ? ret : 3) == 0) {
				struct resource * res;
				char ip[BUFSIZ];

				/* PUT [ip-address] */
				if(sscanf(buf, "PUT %s", ip) != 1) {
					sprintf(buf, "%s\r\n", MSG_ERROR);
					writen(cfd, buf, strlen(buf));
				}

				for(res=resources; res!=NULL; res=res->next)
					if(strcmp(res->bind_name, ip) == 0)
						break;
				if(res == NULL) {
					sprintf(buf, "%s\r\n", MSG_ERROR);
					writen(cfd, buf, strlen(buf));
				} else {
					memset(res->bind_name, 0, sizeof(res->bind_name));
					res->used = 0;

					sprintf(buf, "emulator_controller.sh 1 %s", res->name);
					system(buf);

					sprintf(buf, "%s\r\n", MSG_OK);
					writen(cfd, buf, strlen(buf));

					warnx("put %s", ip);
				}
			} else {
				sprintf(buf, "%s\r\n", MSG_ERROR);
				writen(cfd, buf, strlen(buf));
			}
		}

		close(cfd);
	}
}

