#include "stateful_module.h"
#include "err.h"

#include <string.h>
#include <stdlib.h>

void * default_layer1_write_module(struct connection * connection, struct packet_attribute attr);	/* checksum */
void * default_layer2_write_module(struct connection * connection, struct packet_attribute attr);
void * default_layer3_write_module(struct connection * connection, struct packet_attribute attr);
void * default_layer4_write_module(struct connection * connection, struct packet_attribute attr);
void * default_layer5_write_module(struct connection * connection, struct packet_attribute attr);
void * default_layer7_write_module(struct connection * connection, struct packet_attribute attr);

void * default_layer1_read_module(struct connection * connection, struct packet_attribute attr);	/* checksum */
void * default_layer2_read_module(struct connection * connection, struct packet_attribute attr);
void * default_layer3_read_module(struct connection * connection, struct packet_attribute attr);
void * default_layer4_read_module(struct connection * connection, struct packet_attribute attr);
void * default_layer5_read_module(struct connection * connection, struct packet_attribute attr);
void * default_layer7_read_module(struct connection * connection, struct packet_attribute attr);

void * default_layer1_writeback_module(struct connection * connection, struct packet_attribute attr);	/* checksum */
void * default_layer2_writeback_module(struct connection * connection, struct packet_attribute attr);
void * default_layer3_writeback_module(struct connection * connection, struct packet_attribute attr);
void * default_layer4_writeback_module(struct connection * connection, struct packet_attribute attr);
void * default_layer5_writeback_module(struct connection * connection, struct packet_attribute attr);
void * default_layer7_writeback_module(struct connection * connection, struct packet_attribute attr);


struct stateful_module {
	func function;
	struct stateful_module * next;
};

/* layer 1,2,3,4,5,6,7 */
static struct stateful_module * write_modules[7], * read_modules[7], * writeback_modules[7];

int stateful_module_init()
{
	memset(write_modules, 0, sizeof(struct stateful_module *) * 7);
	memset(read_modules, 0, sizeof(struct stateful_module *) * 7);
	memset(writeback_modules, 0, sizeof(struct stateful_module *) * 7);

	if(!at_stateful_module(1, default_layer1_write_module, OP_WRITE)) { warnx("stateful_module_init: at_stateful_module"); return 0; }
	if(!at_stateful_module(2, default_layer2_write_module, OP_WRITE)) { warnx("stateful_module_init: at_stateful_module"); return 0; }
	if(!at_stateful_module(3, default_layer3_write_module, OP_WRITE)) { warnx("stateful_module_init: at_stateful_module"); return 0; }
	if(!at_stateful_module(4, default_layer4_write_module, OP_WRITE)) { warnx("stateful_module_init: at_stateful_module"); return 0; }
	if(!at_stateful_module(5, default_layer5_write_module, OP_WRITE)) { warnx("stateful_module_init: at_stateful_module"); return 0; }
	if(!at_stateful_module(7, default_layer7_write_module, OP_WRITE)) { warnx("stateful_module_init: at_stateful_module"); return 0; }

	if(!at_stateful_module(1, default_layer1_read_module, OP_READ)) { warnx("stateful_module_init: at_stateful_module"); return 0; }
	if(!at_stateful_module(2, default_layer2_read_module, OP_READ)) { warnx("stateful_module_init: at_stateful_module"); return 0; }
	if(!at_stateful_module(3, default_layer3_read_module, OP_READ)) { warnx("stateful_module_init: at_stateful_module"); return 0; }
	if(!at_stateful_module(4, default_layer4_read_module, OP_READ)) { warnx("stateful_module_init: at_stateful_module"); return 0; }
	if(!at_stateful_module(5, default_layer5_read_module, OP_READ)) { warnx("stateful_module_init: at_stateful_module"); return 0; }
	if(!at_stateful_module(7, default_layer7_read_module, OP_READ)) { warnx("stateful_module_init: at_stateful_module"); return 0; }

	if(!at_stateful_module(1, default_layer1_writeback_module, OP_WRITEBACK)) { warnx("stateful_module_init: at_stateful_module"); return 0; }
	if(!at_stateful_module(2, default_layer2_writeback_module, OP_WRITEBACK)) { warnx("stateful_module_init: at_stateful_module"); return 0; }
	if(!at_stateful_module(3, default_layer3_writeback_module, OP_WRITEBACK)) { warnx("stateful_module_init: at_stateful_module"); return 0; }
	if(!at_stateful_module(4, default_layer4_writeback_module, OP_WRITEBACK)) { warnx("stateful_module_init: at_stateful_module"); return 0; }
	if(!at_stateful_module(5, default_layer5_writeback_module, OP_WRITEBACK)) { warnx("stateful_module_init: at_stateful_module"); return 0; }
	if(!at_stateful_module(7, default_layer7_writeback_module, OP_WRITEBACK)) { warnx("stateful_module_init: at_stateful_module"); return 0; }

	return 1;
}

int at_stateful_module(int layer, func function, int op)
{
	struct stateful_module ** modules=NULL, * new_module;

	if(layer < 1 && layer > 7) warnx("at_stateful_module: unsupport layer: %d", layer);
	switch(op) {
		case OP_WRITE: modules = write_modules; break;
		case OP_READ: modules = read_modules; break;
		case OP_WRITEBACK: modules = writeback_modules; break;
		default: warnx("at_stateful_module: unsupport op: %d", op); break;
	}

	if((new_module = (struct stateful_module *) malloc(sizeof(struct stateful_module))) == NULL) { warn("at_stateful_module: malloc"); return 0; }
	memset(new_module, 0, sizeof(struct stateful_module));
	new_module->function = function;

	if(modules[layer-1] == NULL) modules[layer-1] = new_module;
	else {
		struct stateful_module * m;

		for(m=modules[layer-1]; m->next!=NULL; m=m->next) ;
		m->next = new_module;
	}

	return 1;
}

void layer_stateful_modules(struct connection * connection, struct packet_attribute attr, int layer, int op)
{
	struct stateful_module * m, ** modules=NULL;

	if(layer < 1 && layer > 7) warnx("layer_stateful_modules: unsupport layer: %d", layer);
	switch(op) {
		case OP_WRITE: modules = write_modules; break;
		case OP_READ: modules = read_modules; break;
		case OP_WRITEBACK: modules = writeback_modules; break;
		default: warnx("layer_stateful_modules: unsupport op: %d", op); break;
	}

	for(m=modules[layer-1]; m!=NULL; m=m->next) {
		m->function(connection, attr);
	}
}

