#include <pcap.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/time.h>
#include <err.h>

#include "pcap_dumper.h"

int pcap_dumper_init(struct pcap_dumper * pcap_dumper)
{
	if((pcap_dumper->pcap_dump_pcap = pcap_open_dead(DLT_EN10MB, 2000)) == NULL) { warnx("pcap_open_dead\n"); return 0; }
	if((pcap_dumper->pcap_dump_dumper = pcap_dump_open(pcap_dumper->pcap_dump_pcap, pcap_dumper->pcap_dump_filename)) == NULL) { warnx("pcap_dump_open\n"); return 0; }

	return 1;
}

void pcap_dumper_deinit(struct pcap_dumper * pcap_dumper)
{
	if(pcap_dumper->pcap_dump_dumper != NULL) {
		pcap_dump_flush(pcap_dumper->pcap_dump_dumper);
		pcap_dump_close(pcap_dumper->pcap_dump_dumper);
	}
}

void pcap_dumper_dump(struct pcap_dumper * pcap_dumper, char * packet, u_int32_t len)
{
	struct timeval tv;
	struct pcap_pkthdr pkthdr;

	/* get time stamp */
	memset(&tv, 0, sizeof(struct timeval));
	if(gettimeofday(&tv, NULL) == -1) printf("gettimeofday : %s\n", strerror(errno));

	memset(&pkthdr, 0, sizeof(struct pcap_pkthdr));
	pkthdr.ts = tv;
	pkthdr.caplen = len;
	pkthdr.len = len;

	pcap_dump((u_char *) pcap_dumper->pcap_dump_dumper, &pkthdr, (u_char *) packet);
	pcap_dump_flush(pcap_dumper->pcap_dump_dumper);
}

