#ifndef __PACKET_PARSER_H__
#define __PACKET_PARSER_H__

#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>

struct packet_attribute {
	struct ethhdr * ether_header;
	struct iphdr * ip_header;
	struct tcphdr * tcp_header;
	struct udphdr * udp_header;

	/* Layer 2 flags */
	u_int32_t arp;
	u_int32_t ip;

	/* Layer 3.5 flags */
	u_int32_t icmp;

	/* Layer 4 flags */
	u_int32_t tcp;
	u_int32_t udp;

	u_int32_t tcp_data_len;
	u_int32_t tcp_header_len;
};

struct packet_attribute packet_parse(char * packet);

#endif
