#include "packet_attribute_parser.h"

#include <linux/if_ether.h>
#include <string.h>
#include <sys/types.h>

struct packet_attribute packet_parse(char * packet)
{
	struct packet_attribute attr;

	memset(&attr, 0, sizeof(struct packet_attribute));

	attr.ether_header = (struct ethhdr *) packet;
	switch(ntohs(attr.ether_header->h_proto)) {
		//switch(attr.ether_header->h_proto) {
		case ETH_P_IP:
			{
				attr.ip = 1;
				attr.ip_header = (struct iphdr *) (packet + sizeof(struct ethhdr));
				switch(attr.ip_header->protocol) {
					case IPPROTO_TCP:
						attr.tcp = 1;
						attr.tcp_header = (struct tcphdr *) (packet + sizeof(struct ethhdr) + (attr.ip_header->ihl<<2));
						attr.tcp_data_len = ntohs(attr.ip_header->tot_len) - (attr.ip_header->ihl<<2) - (attr.tcp_header->doff<<2);
						attr.tcp_header_len = attr.tcp_header->doff<<2;
						break;
					case IPPROTO_UDP:
						attr.udp = 1;
						attr.udp_header = (struct udphdr *) (packet + sizeof(struct ethhdr) + (attr.ip_header->ihl<<2));
						break;
					case IPPROTO_ICMP:
						attr.icmp = 1;
						break;
					default:
						break;
				}
			}
			break;
		case ETH_P_ARP:
			{
				attr.arp = 1;
			}
			break;
		default:
			break;
	}

	return attr;
	}
