#ifndef __MAIN_H__
#define __MAIN_H__

#include "packet_attribute_parser.h"
#include "pcap_dumper.h"

#include <linux/types.h>
#include <arpa/inet.h>
#include <linux/types.h>
#include <linux/un.h>

#include <netinet/in.h>
#include <netinet/ether.h>

#include <libnetfilter_queue/libnetfilter_queue.h>
#include <netpacket/packet.h>
#include <linux/netfilter.h>

#include <sys/time.h>

#ifndef IP_LENGTH
#define IP_LENGTH 16
#endif
#ifndef IF_LENGTH
#define IF_LENGTH 256
#endif
#ifndef FILENAME_LENGTH
#define FILENAME_LENGTH 256
#endif

struct dispatcher_config {
	/* required */
	u_int8_t bot_mac_on;
	struct ether_addr bot_mac;

	u_int8_t gateway_mac_on;
	struct ether_addr gateway_mac;

	u_int8_t verdict_on;
	u_int32_t verdict;



	/* optional: three phase of change traffic path */
	u_int8_t bot_if_on;
	char bot_if[IF_LENGTH];
	u_int32_t bot_if_index;

	u_int8_t bot_ip_on;
	char bot_ip[IP_LENGTH];

	/* redirection */
	u_int8_t decoy_if_on;
	char decoy_if[IF_LENGTH];
	u_int32_t decoy_if_index;

	/* IPC with emulator controller */
	u_int8_t ipc_emulator_controller_on;
	u_int32_t ipc_emulator_controller_fd;
	char ipc_emulator_controller_ip[IP_LENGTH];
#ifndef IPC_EMULATOR_CONTROLLER_DEFAULT_PORT
#define IPC_EMULATOR_CONTROLLER_DEFAULT_PORT 48080
#endif
	u_int16_t ipc_emulator_controller_port;
	struct sockaddr_in ipc_emulator_controller_addr;

	u_int8_t decoy_controller_on;

	/* IPC with snort */
	u_int8_t ipc_snort_on;
	u_int32_t ipc_snort_fd;
	char ipc_snort_path[UNIX_PATH_MAX];


	/* optional: miscellaneous */
	u_int8_t blacklist_on;

	u_int8_t log_on;
	char log_filename[FILENAME_LENGTH];
	int log_fd;

	u_int16_t queue_number;

	u_int8_t reinject_on;
	char reinject_filename[FILENAME_LENGTH];

	u_int8_t queued_packets_pcap_dump_on;
	struct pcap_dumper queued_packets_pcap_dumper;

	u_int8_t emulation_packets_pcap_dump_on;
	struct pcap_dumper emulation_packets_pcap_dumper;

	u_int8_t quiet;
	

	/* statistic */
	u_int64_t byte_count;
	u_int64_t packet_count;
	u_int64_t connection_count;
	u_int64_t session_count;

	u_int64_t replay_session_count;

	u_int8_t replay_timestamp_on;
	struct timeval replay_timestamp;
	u_int64_t replayed_byte_count;
	u_int64_t replayed_packet_count;
	u_int64_t replayed_connection_count;

	u_int8_t redirect_timestamp_on;
	struct timeval redirect_timestamp;
	u_int64_t redirected_byte_count;
	u_int64_t redirected_packet_count;
	u_int64_t redirected_connection_count;

	u_int8_t relay_timestamp_on;
	struct timeval relay_timestamp;
	u_int64_t relayed_byte_count;
	u_int64_t relayed_packet_count;
	u_int64_t relayed_connection_count;

	u_int64_t drop_byte_count;
	u_int64_t drop_packet_count;
	u_int64_t drop_connection_count;
	u_int64_t drop_session_count;

	u_int64_t alert_message_count;
};

#endif

