#include "hash_map.h"

#include <search.h>
#include <stdlib.h>
#include <string.h>
#include <err.h>

#ifndef HASHTABLE_MAX_SIZE
#define HASHTABLE_MAX_SIZE 40960
#endif

struct hash_map_entry {
	struct entry entry;
	struct hash_map_entry * next;
};
static struct hash_map_entry * head, * tail;

int hash_map_init(void)
{
	if((tail = (struct hash_map_entry *) malloc(sizeof(struct hash_map_entry))) == NULL) { warn("malloc"); return -1; }
	head = tail;

	return hcreate(HASHTABLE_MAX_SIZE) == 0 ? -1 : 0;
}

void hash_map_deinit(void)
{
	hdestroy();
}

int hash_map_put(char * key, void * data)
{
	struct hash_map_entry * entry;

	if((entry = (struct hash_map_entry *) malloc(sizeof(struct hash_map_entry))) == NULL) { warn("malloc"); return -1; }
	memset(entry, 0, sizeof(struct hash_map_entry));

	tail->next = entry;

	if((entry->entry.key = strdup(key)) == NULL) { warn("strdup"); return -1; }
	entry->entry.data = data;
	if(hsearch(entry->entry, ENTER) == NULL) { warn("hsearch"); return -1; }
	else { return 0; }
}

void * hash_map_get(char * key)
{
	struct hash_map_entry entry;
	struct entry * find_entry;

	entry.entry.key = key;
	find_entry = hsearch(entry.entry, FIND);
	return find_entry == NULL ? NULL : find_entry->data;
}

