#include "err.h"
#include "main.h"

#include <stdarg.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

/* strcat should bring bugs */
void warn(char * fmt, ...)
{
	char msg[BUFSIZ];
	va_list ap;

	va_start(ap, fmt);
	if(fmt != NULL) {
		memset(msg, 0, BUFSIZ);
		vsprintf(msg, fmt, ap);
		strcat(msg, ": ");
		strcat(msg, strerror(errno));
		warnx("%s", msg);
	}
	va_end(ap);
}

extern struct dispatcher_config config;
void warnx(char * fmt, ...)
{
	char msg[BUFSIZ];
	va_list ap;
	int msg_len;

	va_start(ap, fmt);
	if(fmt != NULL) {
		memset(msg, 0, BUFSIZ);
		vsprintf(msg, fmt, ap);
		strcat(msg, "\n");
		msg_len = strlen(msg);

		if(config.log_on) {
			int ret;

			if(config.log_fd != 0) {
				if((ret = write(config.log_fd, msg, msg_len)) <= 0) { fprintf(stderr, "write error: %s [%s]\n", strerror(errno), msg); exit(-1); }   /* avoid recursive function call */
				else if(ret != msg_len) { fprintf(stderr, "write length not match"); }
			}

			if(!config.quiet) {
				int ret;

				if((ret = write(1, msg, msg_len)) <= 0) { fprintf(stderr, "write error: %s [%s]\n", strerror(errno), msg); exit(-1); }
				else if(ret != msg_len) { fprintf(stderr, "write length not match"); }
			}
		} else {
			fprintf(stderr, "%s", msg);
		}
	}
	va_end(ap);
}

void err(int evalue, char * fmt, ...)
{
	warn(fmt);
	exit(evalue);
}

void errx(int evalue, char * fmt, ...)
{
	warnx(fmt);
	exit(evalue);
}

