#include "packet_attribute_parser.h"
#include "core.h"
#include "hash_map.h"
#include "err.h"

#include <stdio.h>
#include <string.h>
#include <openssl/des.h>
#include <openssl/md5.h>
#include <openssl/md4.h>

struct layer5_state_bucket {
#ifndef STATE_BUCKET_KEY_LENGTH
#define STATE_BUCKET_KEY_LENGTH 100
#endif
    char key[STATE_BUCKET_KEY_LENGTH];

    u_int16_t smb_pretid, smb_tid;
    u_int16_t smb_prepid, smb_pid;
    u_int16_t smb_preuid, smb_uid;
    u_int16_t smb_premid, smb_mid;
    u_int16_t smb_fid;
};

struct layer5_state_bucket * get_layer5_state_bucket(struct connection * connection);


void * default_layer5_write_module(struct connection * connection, struct packet_attribute attr)
{
	if(!attr.ip || !attr.tcp) return NULL;

	/* samba heuristic */
	if((connection->dport == 139 || connection->dport == 445) && (attr.tcp_data_len > 34)) {
		struct layer5_state_bucket * bucket;
		char * tcp_payload;
		u_int16_t * tid, * pid, * uid, * mid, tmpid, * fid;
		u_int8_t * cmd;

		if((bucket = get_layer5_state_bucket(connection)) == NULL) { warnx("default_layer5_write_module: get_layer5_state_bucket"); return NULL; }

		tcp_payload = ((char *) attr.tcp_header) + attr.tcp_header_len;

		tid = (u_int16_t *) (tcp_payload + 28); tmpid = *tid;
		if(bucket->smb_pretid == 0) {
			if(bucket->smb_tid != 0) { *tid = bucket->smb_tid; }
		} else {
			if(bucket->smb_pretid != *tid) {
				/* write your original */
			} else {
				if(bucket->smb_tid != 0) { *tid = bucket->smb_tid; }
			}
		}
		bucket->smb_pretid = tmpid;

		pid = (u_int16_t *) (tcp_payload + 30);
		tmpid = *pid;
		if(bucket->smb_prepid == 0) {
			if(bucket->smb_pid != 0) { *pid = bucket->smb_pid; }
		} else {
			if(bucket->smb_prepid != *pid) {
				/* write your original */
			} else {
				if(bucket->smb_pid != 0) { *pid = bucket->smb_pid; }
			}
		}
		bucket->smb_prepid = tmpid;

		uid = (u_int16_t *) (tcp_payload + 32);
		tmpid = *uid;
		if(bucket->smb_preuid == 0) {
			if(bucket->smb_uid != 0) { *uid = bucket->smb_uid; }
		} else {
			if(bucket->smb_preuid != *uid) {
				/* write your original */
			} else {
				if(bucket->smb_uid != 0) { *uid = bucket->smb_uid; }
			}
		}
		bucket->smb_preuid = tmpid;

		mid = (u_int16_t *) (tcp_payload + 34);
		tmpid = *mid;
		if(bucket->smb_premid == 0) {
			if(bucket->smb_mid != 0) { *mid = bucket->smb_mid; }
		} else {
			if(bucket->smb_premid != *mid) {
				/* write your original */
			} else {
				if(bucket->smb_mid != 0) { *mid = bucket->smb_mid; }
			}
		}
		bucket->smb_premid = tmpid;

		cmd = (u_int8_t *) (tcp_payload + 8);
		if(*cmd == 0x2e || *cmd == 0x2f) {
			fid = (u_int16_t *) (tcp_payload + 41); *fid = bucket->smb_fid;
		} else if(*cmd == 0x25) {
			fid = (u_int16_t *) (tcp_payload + 67); *fid = bucket->smb_fid;
		} else if(*cmd == 0x04) {
			fid = (u_int16_t *) (tcp_payload + 37); *fid = bucket->smb_fid;
		}
	}

	return NULL;
}

void * default_layer5_read_module(struct connection * connection, struct packet_attribute attr)
{
	if(!attr.ip || !attr.tcp) return NULL;

	/* samba heuristic */
	if((connection->sport == 139 || connection->sport == 445) && (attr.tcp_data_len > 34)) {
		struct layer5_state_bucket * bucket;
		char * tcp_payload;
		u_int16_t * tid, * pid, * uid, * mid, * fid;
		u_int8_t * cmd;

		if((bucket = get_layer5_state_bucket(connection)) == NULL) { warnx("default_layer5_read_module: get_layer5_state_bucket"); return NULL; }

		tcp_payload = ((char *) attr.tcp_header) + attr.tcp_header_len;

		tid = (u_int16_t *) ((tcp_payload) + 28); bucket->smb_tid = *tid;
		pid = (u_int16_t *) ((tcp_payload) + 30); bucket->smb_pid = *pid;
		uid = (u_int16_t *) ((tcp_payload) + 32); bucket->smb_uid = *uid;
		mid = (u_int16_t *) ((tcp_payload) + 34); bucket->smb_mid = *mid;

		cmd = (u_int8_t *) (((char *) tcp_payload) + 8);
		if(*cmd == 0xa2) {
			fid = (u_int16_t *) (tcp_payload + 42); bucket->smb_fid = *fid;
		} 
	}

	return NULL;
}

void * default_layer5_writeback_module(struct connection * connection, struct packet_attribute attr)
{
	return NULL;
}

struct layer5_state_bucket * get_layer5_state_bucket(struct connection * connection) {
	char key[STATE_BUCKET_KEY_LENGTH];
	struct layer5_state_bucket * bucket;

	sprintf(key, "l5_%s:%d_%s:%d", connection->session->sip, connection->sport, connection->session->dip, connection->dport);

	if((bucket = hash_map_get(key)) == NULL) {
		if((bucket = (struct layer5_state_bucket *) malloc(sizeof(struct layer5_state_bucket))) == NULL) { warn("get_layer5_state_bucket: malloc"); return NULL; }
		memset(bucket, 0, sizeof(struct layer5_state_bucket));
		strncpy(bucket->key, key, STATE_BUCKET_KEY_LENGTH);

		if(hash_map_put(key, bucket) == -1) { warnx("default_layer5_writeback_module: hash_map_put"); return NULL; }
	}

	return bucket;
}

