#include "packet_attribute_parser.h"
#include "core.h"
#include "main.h"
#include "err.h"
#include "hash_map.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

extern struct dispatcher_config config;

struct layer3_state_bucket {
#ifndef STATE_BUCKET_KEY_LENGTH
#define STATE_BUCKET_KEY_LENGTH 100
#endif
	char key[STATE_BUCKET_KEY_LENGTH];
	u_int32_t original_daddr;
};

struct layer3_state_bucket * get_layer3_state_bucket(struct connection * connection);

/* TODO: strange, bind on tcp */
void * default_layer3_write_module(struct connection * connection, struct packet_attribute attr)
{
	struct layer3_state_bucket * bucket;

	if(!attr.ip || !attr.tcp) return NULL;

	if((bucket = get_layer3_state_bucket(connection)) == NULL) { warnx("default_layer3_write_module: get_layer3_state_bucket"); return NULL; }
	bucket->original_daddr = attr.ip_header->daddr;

	attr.ip_header->daddr = connection->session->decoy->ip;

	return NULL;
}

void * default_layer3_read_module(struct connection * connection, struct packet_attribute attr)
{
	return NULL;
}

void * default_layer3_writeback_module(struct connection * connection, struct packet_attribute attr)
{
	struct layer3_state_bucket * bucket;

	if(!attr.ip || !attr.tcp) return NULL;

	if((bucket = get_layer3_state_bucket(connection)) == NULL) { warnx("default_layer3_writeback_module: get_layer3_state_bucket"); return NULL; }

	attr.ip_header->saddr = bucket->original_daddr;

	return NULL;
}

struct layer3_state_bucket * get_layer3_state_bucket(struct connection * connection)
{
	char key[STATE_BUCKET_KEY_LENGTH];
	struct layer3_state_bucket * bucket;

	sprintf(key, "l3_%s:%d_%s:%d", connection->session->sip, connection->sport, connection->session->dip, connection->dport);
	if((bucket = hash_map_get(key)) == NULL) {
		if((bucket = (struct layer3_state_bucket *) malloc(sizeof(struct layer3_state_bucket))) == NULL) { warn("get_layer3_state_bucket: malloc"); return NULL; }
		memset(bucket, 0, sizeof(struct layer3_state_bucket));
		strncpy(bucket->key, key, STATE_BUCKET_KEY_LENGTH);
		if(hash_map_put(key, bucket) == -1) { warnx("get_layer3_state_bucket: hash_map_put"); return NULL; }
	}

	return bucket;
}
