#include "packet_attribute_parser.h"
#include "err.h"
#include "main.h"
#include "core.h"
#include "decoy.h"

#include <stdio.h>
#include <string.h>

extern struct dispatcher_config config;

void * default_layer2_write_module(struct connection * connection, struct packet_attribute attr)
{
	if(!attr.ip) return NULL;

	memcpy(attr.ether_header->h_dest, &(connection->session->decoy->mac), 6);

	return NULL;
}

void * default_layer2_read_module(struct connection * connection, struct packet_attribute attr)
{
	return NULL;
}

void * default_layer2_writeback_module(struct connection * connection, struct packet_attribute attr)
{
	memcpy(attr.ether_header->h_source, &config.gateway_mac, 6);
	memcpy(attr.ether_header->h_dest, &config.bot_mac, 6);

	return NULL;
}

