#include "decoy.h"
#include "err.h"
#include "main.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <net/ethernet.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netinet/ether.h>

extern struct dispatcher_config config;

struct _decoy {
	struct decoy decoy;
	u_int8_t used_flag, multiple_used_flag;
	struct _decoy * next;
};
static struct _decoy * _decoy = NULL;

int decoy_init(char * arg)
{
	char buf[BUFSIZ], * source, * p, * tmp_p;

	memset(buf, 0, BUFSIZ);
	strncpy(buf, arg, BUFSIZ - 1);
	source = buf;
	while((p = strtok_r(source, ",", &tmp_p)) != NULL) {
		char * pp, * tmp_pp;
		struct _decoy * new_decoy;
		struct ether_addr * addr;

		if((new_decoy = (struct _decoy *) malloc(sizeof(struct _decoy))) == NULL) { warn("decoy_init: malloc"); return 0; }
		memset(new_decoy, 0, sizeof(struct _decoy));

		if((pp = strtok_r(p, "/", &tmp_pp)) == NULL) { warnx("decoy_init: strtok_r: format error"); return 0; }
		if(inet_pton(AF_INET, pp, &new_decoy->decoy.ip) == -1) { warnx("decoy_init: inet_pton"); return 0; }
		{
			static int n = 0;
			char ip[IP_LENGTH+IP_LENGTH], * c, cmd[BUFSIZ];

			memset(ip, 0, IP_LENGTH + IP_LENGTH);
			strncpy(ip, pp, IP_LENGTH + IP_LENGTH - 1);
			if((c = rindex(ip, '.')) == NULL) { warnx("decoy_init: rindex: impossible"); return 0; }
			*(c+1) = 0;
			/* TODO: 222 is a bad idea? */
			strcat(ip, "222");	/* danger function */
			memset(cmd, 0, BUFSIZ);
			sprintf(cmd, "ifconfig %s:%d inet %s netmask 255.255.255.0 up", config.decoy_if, n++, ip);
			system(cmd);	/* here should bring some error message (FILE_EXIST), but we don't care about it */
		}

		if((pp = strtok_r(NULL, "/", &tmp_pp)) == NULL) { warnx("decoy_init: strtok_r: format error"); return 0; }
		if((addr = ether_aton(pp)) == NULL) { warnx("decoy_init: ether_aton: invalid address"); return 0; }
		memcpy(&new_decoy->decoy.mac, addr, sizeof(struct ether_addr));
		if((pp = strtok_r(NULL, "/", &tmp_pp)) == NULL) { warnx("decoy_init: strtok_r: format error"); return 0; }
		if(pp[0] == 'm') new_decoy->multiple_used_flag = 1;

		if(_decoy == NULL) _decoy = new_decoy;
		else {
			struct _decoy * d;

			for(d=_decoy; d->next!=NULL; d=d->next) ;
			d->next = new_decoy;
		}

		source = NULL;
	}

	return 1;
}

struct decoy * get_decoy()
{
	struct _decoy * d;

	for(d=_decoy; d!=NULL; d=d->next) {
		if(d->multiple_used_flag) return &d->decoy;
		if(!d->used_flag) {
			d->used_flag = 1;
			return &d->decoy;
		}
	}

	return NULL;
}

