#ifndef __CORE_H__
#define __CORE_H__

#include "decoy.h"
#include "pcap_dumper.h"

#include <sys/types.h>

struct packet {
	struct connection * connection;

#ifndef PACKET_RESPONSE_SKIP_STATUS
#define PACKET_RESPONSE_SKIP_STATUS 0
#endif
#ifndef PACKET_RESPONSE_WRITEBACK_STATUS
#define PACKET_RESPONSE_WRITEBACK_STATUS 1
#endif
	u_int32_t status;

#ifndef MAX_PACKET_SIZE
#define MAX_PACKET_SIZE 2000
#endif
	char data[MAX_PACKET_SIZE];
	u_int32_t len;
	struct packet * next;
};

struct connection {
	struct session * session;
#ifndef CONNECTION_KEY_LENGTH
#define CONNECTION_KEY_LENGTH 100
#endif
	char key[CONNECTION_KEY_LENGTH];
	u_int16_t sport;
	u_int16_t dport;

#ifndef CONNECTION_REPLAY_STATUS
#define CONNECTION_REPLAY_STATUS 0
#endif
#ifndef CONNECTION_REDIRECT_STATUS
#define CONNECTION_REDIRECT_STATUS 1
#endif
#ifndef CONNECTION_RELAY_STATUS
#define CONNECTION_RELAY_STATUS 2
#endif
	u_int32_t status;

#ifndef CONNECTION_TYPE_TCP
#define CONNECTION_TYPE_TCP 0
#endif
#ifndef CONNECTION_TYPE_UDP
#define CONNECTION_TYPE_UDP 1
#endif
#ifndef CONNECTION_TYPE_ICMP
#define CONNECTION_TYPE_ICMP 2
#endif
	u_int32_t connection_type;

	struct packet * packets;
	struct connection * next;

	pthread_t thread_obj, thread_obj2;
	pthread_mutex_t mutex_obj;
	pthread_cond_t cond_obj;

	u_int8_t handle_by_thread_flag;

	struct pcap_dumper pd;
};

struct session {
#ifndef SESSION_KEY_LENGTH
#define SESSION_KEY_LENGTH 100
#endif
	char key[SESSION_KEY_LENGTH];
#ifndef IP_LENGTH
#define IP_LENGTH 16
#endif
	char sip[IP_LENGTH];
	char dip[IP_LENGTH];

#ifndef SESSION_NORMAL_STATUS
#define SESSION_NORMAL_STATUS 0
#endif
#ifndef SESSION_PATH_CHANGED_STATUS
#define SESSION_PATH_CHANGED_STATUS 1
#endif
#ifndef SESSION_ALERTED
#define SESSION_ALERTED 2
#endif
	u_int32_t status;

	pthread_t thread_obj;
	pthread_mutex_t mutex_obj;
	pthread_cond_t cond_obj;

	struct decoy * decoy;

	struct connection * connections;
};

struct session * get_session(char * sip, char * dip);
struct connection * get_connection(struct session * session, u_int16_t sport, u_int16_t dport);
struct packet * get_packet(struct connection * connection, char * packet, u_int32_t packet_len);

void start_change_path(struct session * session);
void * pthread_start_change_path(void * arg);
void * pthread_start_replay(void * arg);
void * pthread_start_redirect(void * arg);
void * pthread_start_relay(void * arg);
void * pthread_start_relay_receive(void * arg);

u_int32_t get_verdict(struct packet * packet);

#endif
