#include "err.h"
#include "blacklist_module.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netinet/in.h>
#include <arpa/inet.h>

struct blacklist {
	u_int32_t ip;
	u_int16_t port;
	struct blacklist * next;
};

static struct blacklist * blacklist;

int blacklist_module_init(char * arg)
{
	char buf[BUFSIZ], * source, * p, * tmp_p;
	struct blacklist * tail = NULL;;

	memset(buf, 0, BUFSIZ);
	strncpy(buf, arg, BUFSIZ-1);
	source = buf;
	while((p = strtok_r(source, ",", &tmp_p))!= NULL) {
		char * pp, * tmp_pp;
		struct blacklist * bl;

		if((bl = malloc(sizeof(struct blacklist))) == NULL) { warn("blacklist_module_init: malloc"); return 0; }
		memset(bl, 0, sizeof(struct blacklist));

		if(blacklist == NULL) { blacklist = bl; }
		else { tail->next = bl; }
		tail = bl;

		if((pp = strtok_r(p, ":", &tmp_pp)) == NULL) { warnx("blacklist_module_init: strtok_r: format error"); return 0; }
		if(pp[0] != '*') { if(inet_pton(AF_INET, pp, &bl->ip) == -1) { warnx("blacklist_module_init: inet_pton: format error"); return 0; } }

		if((pp = strtok_r(NULL, ":", &tmp_pp)) == NULL) { warnx("blacklist_module_init: strtok_r: format error"); return 0; }
		if(pp[0] != '*') { bl->port = htons(strtol(pp, NULL, 10)); }

		source = NULL;
	}

	warnx("blacklist_module_init");
	return 1;
}

int blacklist_module(char * dip, u_int16_t dport)
{
	struct blacklist * bl;
	u_int32_t ddip;

	if(inet_pton(AF_INET, dip, &ddip) == -1) { warnx("blacklist_module: inet_pton"); return 0; }
	dport = htons(dport);

	/* shit, so stupid way */
	for(bl=blacklist; bl!=NULL; bl=bl->next) {
		if(bl->ip == 0) {
			if(bl->port == 0) return 1;
			else if(bl->port == dport) return 1;
		} else if(bl->ip == ddip) {
			if(bl->port == 0) return 1;
			else if(bl->port == dport) return 1;
		}
	}

	return 0;
}

