/*	   	Copyright (c) 1989, 1990 ERSO/ITRI	*/
/*	   	Copyright (c) 1990 CCL/ITRI		*/
/*		System Software Department CCL/ITRI     */
/*	 	    All Rights Reserved  		*/
/*										*/
/*    Modified to support multiple boards on SCO - k. olsen 4/18/93 */
/*      in particular renamed driver from ether to en16 */

/* space.c */

#include "config.h"

#ifdef EN164_CNTLS
#define MAX_BOARDS (EN164_CNTLS+EN163_CNTLS+EN162_CNTLS+EN161_CNTLS+EN16_CNTLS) 

#elif EN163_CNTLS
#define MAX_BOARDS (EN163_CNTLS+EN162_CNTLS+EN161_CNTLS+EN16_CNTLS) 

#elif EN162_CNTLS
#define MAX_BOARDS (EN162_CNTLS+EN161_CNTLS+EN16_CNTLS) 

#elif EN161_CNTLS
#define MAX_BOARDS (EN161_CNTLS+EN16_CNTLS) 

#else
#define MAX_BOARDS (EN16_CNTLS) 
#endif

int en16_num_dev = MAX_BOARDS;

typedef	struct {
	int  start_addr; /* RAM starting address	*/
	int  end_addr;	 /* RAM ending address	*/
	int  IRQ;	 /* Interrupt 		*/
	int  PORT;	 /* I/O address		*/
} T_en16_sdev;

T_en16_sdev	Sdev[MAX_BOARDS] = {
#ifdef EN16_0
	{
		EN16_0_SCMA, 	/* RAM starting address */
		EN16_0_ECMA,	/* RAM ending address	*/
		EN16_0_VECT,	/* IRQ			*/
		EN16_0_SIOA		/* I/O address		*/
	}
#endif
#ifdef EN161_0
	,
	{
		EN16_0_SCMA, 	/* RAM starting address */
		EN161_0_ECMA,	/* RAM ending address	*/
		EN161_0_VECT,	/* IRQ			*/
		EN161_0_SIOA	/* I/O address		*/
	}
#endif
#ifdef EN162_0
	,
	{
		EN16_0_SCMA, 	/* RAM starting address */
		EN162_0_ECMA,	/* RAM ending address	*/
		EN162_0_VECT,	/* IRQ			*/
		EN162_0_SIOA	/* I/O address		*/
	}
#endif
#ifdef EN163_0
	,
	{
		EN16_0_SCMA, 	/* RAM starting address */
		EN163_0_ECMA,	/* RAM ending address	*/
		EN163_0_VECT,	/* IRQ			*/
		EN163_0_SIOA	/* I/O address		*/
	}
#endif
#ifdef EN164_0
	,
	{
		EN16_0_SCMA, 	/* RAM starting address */
		EN164_0_ECMA,	/* RAM ending address	*/
		EN164_0_VECT,	/* IRQ			*/
		EN164_0_SIOA	/* I/O address		*/
	}
#endif
};
